"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.APICallFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _encode_path_params = require("../../../../shared/encode_path_params");
var _react_router_helpers = require("../../../../shared/react_router_helpers");
var _routes = require("../../../routes");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const APICallFlyout = ({
  engineName,
  onClose,
  lastAPICall
}) => {
  const [tab, setTab] = (0, _react.useState)('request');
  const contents = JSON.stringify(lastAPICall[tab], null, 2);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    size: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.engine.searchPreivew.apiCallFlyout.title",
    defaultMessage: "API Call"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    style: {
      marginBottom: '-24px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    bottomBorder: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: tab === 'request',
    onClick: () => setTab('request')
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.engine.searchPreivew.apiCallFlyout.requestTab",
    defaultMessage: "Request"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: tab === 'response',
    onClick: () => setTab('response')
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.engine.searchPreivew.apiCallFlyout.responseTab",
    defaultMessage: "Response"
  }))), /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
    to: (0, _encode_path_params.generateEncodedPath)(_routes.ENGINE_TAB_PATH, {
      engineName,
      tabId: _routes.EngineViewTabs.CONNECT
    }),
    color: "primary",
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.engine.searchPreivew.apiCallFlyout.searchEndpointLink",
    defaultMessage: "Search endpoint"
  })))), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      blockSize: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    overflowHeight: "100%",
    isCopyable: true,
    isVirtualized: true
  }, contents)));
};
exports.APICallFlyout = APICallFlyout;