"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EngineRouter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _encode_path_params = require("../../../shared/encode_path_params");
var _routes = require("../../routes");
var _engine_name_logic = require("./engine_name_logic");
var _engine_view = require("./engine_view");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EngineRouter = () => {
  const engineName = decodeURIComponent((0, _reactRouterDom.useParams)().engineName);
  const engineNameLogic = (0, _engine_name_logic.EngineNameLogic)({
    engineName
  });
  const {
    setEngineName
  } = (0, _kea.useActions)(engineNameLogic);
  (0, _react.useEffect)(() => {
    const unmountName = engineNameLogic.mount();
    return () => {
      unmountName();
    };
  }, []);
  (0, _react.useEffect)(() => {
    setEngineName(engineName);
  }, [engineName]);
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    from: _routes.ENGINE_PATH,
    to: (0, _encode_path_params.generateEncodedPath)(_routes.ENGINE_TAB_PATH, {
      engineName,
      tabId: _routes.EngineViewTabs.PREVIEW
    }),
    exact: true
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.ENGINE_TAB_PATH
  }, /*#__PURE__*/_react.default.createElement(_engine_view.EngineView, null)));
};
exports.EngineRouter = EngineRouter;