"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EngineNameLogic = void 0;
var _kea = require("kea");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EngineNameLogic = (0, _kea.kea)({
  actions: {
    setEngineName: engineName => ({
      engineName
    })
  },
  path: ['enterprise_search', 'content', 'engine_name'],
  reducers: ({
    props
  }) => {
    var _props$engineName;
    return {
      engineName: [// Short-circuiting this to empty string is necessary to enable testing logics relying on this
      (_props$engineName = props.engineName) !== null && _props$engineName !== void 0 ? _props$engineName : '', {
        setEngineName: (_, {
          engineName
        }) => engineName
      }]
    };
  }
});
exports.EngineNameLogic = EngineNameLogic;