"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EngineIndicesLogic = void 0;
var _kea = require("kea");
var _update_engine_api_logic = require("../../api/engines/update_engine_api_logic");
var _engine_view_logic = require("./engine_view_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EngineIndicesLogic = (0, _kea.kea)({
  actions: {
    addIndicesToEngine: indices => ({
      indices
    }),
    closeAddIndicesFlyout: () => true,
    openAddIndicesFlyout: () => true,
    removeIndexFromEngine: indexName => ({
      indexName
    })
  },
  connect: {
    actions: [_engine_view_logic.EngineViewLogic, ['fetchEngine'], _update_engine_api_logic.UpdateEngineApiLogic, ['makeRequest as updateEngineRequest', 'apiSuccess as engineUpdated']],
    values: [_engine_view_logic.EngineViewLogic, ['engineData', 'engineName', 'isLoadingEngine']]
  },
  listeners: ({
    actions,
    values
  }) => ({
    addIndicesToEngine: ({
      indices
    }) => {
      if (!values.engineData) return;
      const existingIndicesNames = values.engineData.indices.map(index => index.name);
      const updatedIndices = Array.from(new Set([...existingIndicesNames, ...indices]));
      actions.updateEngineRequest({
        engineName: values.engineName,
        indices: updatedIndices
      });
    },
    engineUpdated: () => {
      actions.fetchEngine({
        engineName: values.engineName
      });
    },
    removeIndexFromEngine: ({
      indexName
    }) => {
      if (!values.engineData) return;
      const updatedIndices = values.engineData.indices.filter(index => index.name !== indexName).map(index => index.name);
      actions.updateEngineRequest({
        engineName: values.engineName,
        indices: updatedIndices
      });
    }
  }),
  path: ['enterprise_search', 'content', 'engine_indices_logic'],
  reducers: {
    addIndicesFlyoutOpen: [false, {
      closeAddIndicesFlyout: () => false,
      openAddIndicesFlyout: () => true
    }]
  }
});
exports.EngineIndicesLogic = EngineIndicesLogic;