"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.elasticsearchUrl = exports.SearchApplicationAPI = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _cloud_details = require("../../../../shared/cloud_details/cloud_details");
var _decode_cloud_id = require("../../../../shared/decode_cloud_id/decode_cloud_id");
var _doc_links = require("../../../../shared/doc_links");
var _kibana = require("../../../../shared/kibana");
var _engine_view_logic = require("../engine_view_logic");
var _engine_api_integration = require("./engine_api_integration");
var _engine_api_logic = require("./engine_api_logic");
var _generate_engine_api_key_modal = require("./generate_engine_api_key_modal/generate_engine_api_key_modal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const elasticsearchUrl = cloudContext => {
  var _decodeCloudId;
  const defaultUrl = 'https://localhost:9200';
  const url = cloudContext.cloudId && ((_decodeCloudId = (0, _decode_cloud_id.decodeCloudId)(cloudContext.cloudId)) === null || _decodeCloudId === void 0 ? void 0 : _decodeCloudId.elasticsearchUrl) || defaultUrl;
  return url;
};
exports.elasticsearchUrl = elasticsearchUrl;
const SearchApplicationAPI = () => {
  const {
    engineName
  } = (0, _kea.useValues)(_engine_view_logic.EngineViewLogic);
  const {
    isGenerateModalOpen
  } = (0, _kea.useValues)(_engine_api_logic.EngineApiLogic);
  const {
    openGenerateModal,
    closeGenerateModal
  } = (0, _kea.useActions)(_engine_api_logic.EngineApiLogic);
  const cloudContext = (0, _cloud_details.useCloudDetails)();
  const steps = [{
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchApplication.api.step1.title', {
      defaultMessage: 'Generate and save API key'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.searchApplication.api.step1.apiKeyWarning', {
      defaultMessage: "Elastic does not store API keys. Once generated, you'll only be able to view the key one time. Make sure you save it somewhere secure. If you lose access to it you'll need to generate a new API key from this screen."
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: _doc_links.docLinks.apiKeys,
      "data-telemetry-id": "entSearchApplications-searchApplication-api-step1-learnMoreLink",
      external: true,
      target: "_blank"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.searchApplication.api.step1.learnMoreLink', {
      defaultMessage: 'Learn more about API keys.'
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconSide: "left",
      iconType: "plusInCircleFilled",
      onClick: openGenerateModal,
      "data-telemetry-id": "entSearchApplications-searchApplication-api-step1-createApiKeyButton"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.searchApplication.api.step1.createAPIKeyButton', {
      defaultMessage: 'Create API Key'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconSide: "left",
      iconType: "popout",
      "data-telemetry-id": "entSearchApplications-searchApplication-api-step1-viewKeysButton",
      onClick: () => _kibana.KibanaLogic.values.navigateToUrl('/app/management/security/api_keys', {
        shouldNotCreateHref: true
      })
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.searchApplication.api.step1.viewKeysButton', {
      defaultMessage: 'View Keys'
    })))))
  }, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchApplication.api.step2.title', {
      defaultMessage: "Copy your search application's endpoint"
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.searchApplication.api.step2.copyEndpointDescription', {
      defaultMessage: "Use this URL to access your search application's API endpoints."
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "markup",
      fontSize: "m",
      paddingSize: "m",
      isCopyable: true
    }, elasticsearchUrl(cloudContext)))))
  }, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchApplication.api.step3.title', {
      defaultMessage: 'Learn how to call your endpoints'
    }),
    children: /*#__PURE__*/_react.default.createElement(_engine_api_integration.EngineApiIntegrationStage, null)
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isGenerateModalOpen ? /*#__PURE__*/_react.default.createElement(_generate_engine_api_key_modal.GenerateEngineApiKeyModal, {
    engineName: engineName,
    onClose: closeGenerateModal
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    headingElement: "h2",
    steps: steps
  }));
};
exports.SearchApplicationAPI = SearchApplicationAPI;