"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GenerateApiKeyModalLogic = void 0;
var _kea = require("kea");
var _api = require("../../../../../../../common/types/api");
var _generate_engine_api_key_logic = require("../../../../../enterprise_search_content/api/generate_engine_api_key/generate_engine_api_key_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GenerateApiKeyModalLogic = (0, _kea.kea)({
  actions: {
    setKeyName: keyName => ({
      keyName
    })
  },
  connect: {
    values: [_generate_engine_api_key_logic.GenerateEngineApiKeyLogic, ['data', 'status']]
  },
  path: ['enterprise_search', 'engines', 'api', 'generate_api_key_modal'],
  reducers: () => ({
    keyName: ['', {
      setKeyName: (_, {
        keyName
      }) => keyName
    }]
  }),
  selectors: ({
    selectors
  }) => ({
    apiKey: [() => [selectors.data], data => {
      var _data$apiKey;
      return (data === null || data === void 0 ? void 0 : (_data$apiKey = data.apiKey) === null || _data$apiKey === void 0 ? void 0 : _data$apiKey.encoded) || '';
    }],
    isLoading: [() => [selectors.status], status => status === _api.Status.LOADING],
    isSuccess: [() => [selectors.status], status => status === _api.Status.SUCCESS]
  })
});
exports.GenerateApiKeyModalLogic = GenerateApiKeyModalLogic;