"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GenerateEngineApiKeyModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _generate_engine_api_key_logic = require("../../../../../enterprise_search_content/api/generate_engine_api_key/generate_engine_api_key_logic");
var _generate_engine_api_key_modal = require("./generate_engine_api_key_modal.logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GenerateEngineApiKeyModal = ({
  engineName,
  onClose
}) => {
  const {
    keyName,
    apiKey,
    isLoading,
    isSuccess
  } = (0, _kea.useValues)(_generate_engine_api_key_modal.GenerateApiKeyModalLogic);
  const {
    setKeyName
  } = (0, _kea.useActions)(_generate_engine_api_key_modal.GenerateApiKeyModalLogic);
  const {
    makeRequest
  } = (0, _kea.useActions)(_generate_engine_api_key_logic.GenerateEngineApiKeyLogic);
  (0, _react.useEffect)(() => {
    setKeyName(`${engineName} read-only API key`);
  }, [engineName]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onClose
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, _i18n.i18n.translate('xpack.enterpriseSearch.content.engine.api.generateEngineApiKeyModal.title', {
    defaultMessage: 'Create Search application read-only API Key'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    color: "primary"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "flexEnd"
  }, !isSuccess ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "Name your API key",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-telemetry-id": "entSearchApplications-api-generateEngineApiKeyModal-editName",
    fullWidth: true,
    placeholder: "Type a name for your API key",
    onChange: event => setKeyName(event.currentTarget.value),
    value: keyName,
    isLoading: isLoading
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-telemetry-id": "entSearchApplications-api-generateEngineApiKeyModal-generateApiKeyButton",
    "data-test-subj": "generateApiKeyButton",
    iconSide: "left",
    iconType: "plusInCircle",
    fill: true,
    onClick: () => {
      makeRequest({
        engineName,
        keyName: keyName.trim()
      });
    },
    disabled: keyName.trim().length <= 0
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.engine.api.generateEngineApiKeyModal.generateButton', {
    defaultMessage: 'Generate read-only key'
  })))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, null, keyName), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    "aria-label": keyName,
    fontSize: "m",
    paddingSize: "m",
    color: "dark",
    isCopyable: true
  }, apiKey)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-telemetry-id": "entSearchApplications-api-generateEngineApiKeyModal-csvDownloadButton",
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.content.engine.api.generateEngineApiKeyModal.csvDownloadButton', {
      defaultMessage: 'Download API key'
    }),
    iconType: "download",
    href: encodeURI(`data:text/csv;charset=utf-8,${apiKey}`),
    download: `${keyName}.csv`
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "#006bb8"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.engine.api.generateEngineApiKeyModal.apiKeyWarning', {
    defaultMessage: "Elastic does not store API keys. Once generated, you'll only be able to view the key one time. Make sure you save it somewhere secure. If you lose access to it you'll need to generate a new API key from this screen."
  })))))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, apiKey ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-telemetry-id": "entSearchApplications-api-generateEngineApiKeyModal-done",
    fill: true,
    onClick: onClose
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.engine.api.generateEngineApiKeyModal.done', {
    defaultMessage: 'Done'
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-telemetry-id": "entSearchApplications-api-generateEngineApiKeyModal-cancel",
    onClick: onClose
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.engine.api.generateEngineApiKeyModal.cancel', {
    defaultMessage: 'Cancel'
  }))));
};
exports.GenerateEngineApiKeyModal = GenerateEngineApiKeyModal;