"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EngineConnect = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _i18n = require("@kbn/i18n");
var _encode_path_params = require("../../../../shared/encode_path_params");
var _kibana = require("../../../../shared/kibana");
var _routes = require("../../../routes");
var _engines_page_template = require("../../layout/engines_page_template");
var _engine_error = require("../engine_error");
var _engine_view_logic = require("../engine_view_logic");
var _search_application_api = require("./search_application_api");
require("../search_application_layout.scss");
var _search_application_documentation = require("./search_application_documentation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const pageTitle = _i18n.i18n.translate('xpack.enterpriseSearch.content.searchApplications.connect.pageTitle', {
  defaultMessage: 'Connect'
});
const API_TAB_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.content.searchApplications.connect.apiTabTitle', {
  defaultMessage: 'API'
});
const DOCUMENTATION_TAB_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.content.searchApplications.connect.documentationTabTitle', {
  defaultMessage: 'Documentation'
});
const ConnectTabs = Object.values(_routes.SearchApplicationConnectTabs);
const getTabBreadCrumb = tabId => {
  switch (tabId) {
    case _routes.SearchApplicationConnectTabs.API:
      return API_TAB_TITLE;
    case _routes.SearchApplicationConnectTabs.DOCUMENTATION:
      return DOCUMENTATION_TAB_TITLE;
    default:
      return tabId;
  }
};
const EngineConnect = () => {
  const {
    engineName,
    isLoadingEngine
  } = (0, _kea.useValues)(_engine_view_logic.EngineViewLogic);
  const {
    connectTabId = _routes.SearchApplicationConnectTabs.API
  } = (0, _reactRouterDom.useParams)();
  const onTabClick = tab => () => {
    _kibana.KibanaLogic.values.navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_APPLICATION_CONNECT_PATH, {
      connectTabId: tab,
      engineName
    }));
  };
  if (!ConnectTabs.includes(connectTabId)) {
    return /*#__PURE__*/_react.default.createElement(_engines_page_template.EnterpriseSearchEnginesPageTemplate, {
      pageChrome: [engineName, pageTitle],
      pageViewTelemetry: _routes.EngineViewTabs.CONNECT,
      isLoading: isLoadingEngine,
      pageHeader: {
        bottomBorder: false,
        className: 'searchApplicationHeaderBackgroundColor',
        pageTitle,
        rightSideItems: []
      },
      engineName: engineName
    }, /*#__PURE__*/_react.default.createElement(_engine_error.EngineError, {
      notFound: true
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_engines_page_template.EnterpriseSearchEnginesPageTemplate, {
    pageChrome: [engineName, pageTitle, getTabBreadCrumb(connectTabId)],
    pageViewTelemetry: _routes.EngineViewTabs.CONNECT,
    isLoading: isLoadingEngine,
    pageHeader: {
      bottomBorder: false,
      className: 'searchApplicationHeaderBackgroundColor',
      pageTitle,
      rightSideItems: [],
      tabs: [{
        isSelected: connectTabId === _routes.SearchApplicationConnectTabs.API,
        label: API_TAB_TITLE,
        onClick: onTabClick(_routes.SearchApplicationConnectTabs.API)
      }, {
        isSelected: connectTabId === _routes.SearchApplicationConnectTabs.DOCUMENTATION,
        label: DOCUMENTATION_TAB_TITLE,
        onClick: onTabClick(_routes.SearchApplicationConnectTabs.DOCUMENTATION)
      }]
    },
    engineName: engineName
  }, connectTabId === _routes.SearchApplicationConnectTabs.API && /*#__PURE__*/_react.default.createElement(_search_application_api.SearchApplicationAPI, null), connectTabId === _routes.SearchApplicationConnectTabs.DOCUMENTATION && /*#__PURE__*/_react.default.createElement(_search_application_documentation.SearchApplicationDocumentation, null));
};
exports.EngineConnect = EngineConnect;