"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EngineApiLogic = void 0;
var _kea = require("kea");
var _api = require("../../../../../../common/types/api");
var _generate_engine_api_key_logic = require("../../../../enterprise_search_content/api/generate_engine_api_key/generate_engine_api_key_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EngineApiLogic = (0, _kea.kea)({
  actions: {
    closeGenerateModal: true,
    openGenerateModal: true
  },
  connect: {
    actions: [_generate_engine_api_key_logic.GenerateEngineApiKeyLogic, ['apiReset']],
    values: [_generate_engine_api_key_logic.GenerateEngineApiKeyLogic, ['data as apiKeyData', 'status as apiKeyStatus']]
  },
  listeners: ({
    actions
  }) => ({
    openGenerateModal: () => {
      actions.apiReset();
    }
  }),
  path: ['enterprise_search', 'content', 'engine_api_logic'],
  reducers: () => ({
    isGenerateModalOpen: [false, {
      closeGenerateModal: () => false,
      openGenerateModal: () => true
    }]
  }),
  selectors: ({
    selectors
  }) => ({
    apiKey: [() => [selectors.apiKeyStatus, selectors.apiKeyData], (apiKeyStatus, apiKeyData) => apiKeyStatus === _api.Status.SUCCESS ? apiKeyData.apiKey.encoded : null]
  })
});
exports.EngineApiLogic = EngineApiLogic;