"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EngineApiIntegrationStage = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _cloud_details = require("../../../../shared/cloud_details/cloud_details");
var _engine_view_logic = require("../engine_view_logic");
var _engine_api_logic = require("./engine_api_logic");
var _search_application_api = require("./search_application_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchUISnippet = (esUrl, engineName, apiKey) => `
import EnginesAPIConnector from "@elastic/search-ui-engines-connector";

const connector = new EnginesAPIConnector({
  host: "${esUrl}",
  engineName: "${engineName}",
  apiKey: "${apiKey || '<YOUR_API_KEY>'}"
});`;
const cURLSnippet = (esUrl, engineName, apiKey) => `
curl --location --request GET '${esUrl}/${engineName}/_search' \\
--header 'Authorization: apiKey ${apiKey || '<YOUR_API_KEY>'}' \\
--header 'Content-Type: application/json' \\
--data-raw '{
  "query": {
    "match_all": {}
  }
}'`;
const EngineApiIntegrationStage = () => {
  const [selectedTab, setSelectedTab] = _react.default.useState('curl');
  const {
    engineName
  } = (0, _kea.useValues)(_engine_view_logic.EngineViewLogic);
  const {
    apiKey
  } = (0, _kea.useValues)(_engine_api_logic.EngineApiLogic);
  const cloudContext = (0, _cloud_details.useCloudDetails)();
  const Tabs = {
    curl: {
      code: cURLSnippet((0, _search_application_api.elasticsearchUrl)(cloudContext), engineName, apiKey),
      language: 'bash',
      title: _i18n.i18n.translate('xpack.enterpriseSearch.content.engine.api.step3.curlTitle', {
        defaultMessage: 'cURL'
      })
    },
    searchui: {
      code: SearchUISnippet((0, _search_application_api.elasticsearchUrl)(cloudContext), engineName, apiKey),
      language: 'javascript',
      title: _i18n.i18n.translate('xpack.enterpriseSearch.content.engine.api.step3.searchUITitle', {
        defaultMessage: 'Search UI'
      })
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.engine.api.step3.intro', {
    defaultMessage: 'Use the following code snippets to connect to your search application.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, null, Object.entries(Tabs).map(([tabId, tab]) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: tabId,
    isSelected: selectedTab === tabId,
    onClick: () => setSelectedTab(tabId),
    "data-telemetry-id": `entSearchApplications-api-integration-tab-${tabId}`
  }, tab.title))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true,
    lang: Tabs[selectedTab].language
  }, Tabs[selectedTab].code));
};
exports.EngineApiIntegrationStage = EngineApiIntegrationStage;