"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddIndicesLogic = void 0;
var _kea = require("kea");
var _update_engine_api_logic = require("../../api/engines/update_engine_api_logic");
var _engine_indices_logic = require("./engine_indices_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddIndicesLogic = (0, _kea.kea)({
  actions: {
    setSelectedIndices: indices => ({
      indices
    }),
    submitSelectedIndices: () => true
  },
  connect: {
    actions: [_engine_indices_logic.EngineIndicesLogic, ['addIndicesToEngine', 'engineUpdated', 'closeAddIndicesFlyout']],
    values: [_update_engine_api_logic.UpdateEngineApiLogic, ['status as updateEngineStatus', 'error as updateEngineError']]
  },
  listeners: ({
    actions,
    values
  }) => ({
    engineUpdated: () => {
      actions.closeAddIndicesFlyout();
    },
    submitSelectedIndices: () => {
      const {
        selectedIndices
      } = values;
      if (selectedIndices.length === 0) return;
      actions.addIndicesToEngine(selectedIndices);
    }
  }),
  path: ['enterprise_search', 'content', 'add_indices_logic'],
  reducers: {
    selectedIndices: [[], {
      closeAddIndicesFlyout: () => [],
      setSelectedIndices: (_, {
        indices
      }) => indices
    }]
  }
});
exports.AddIndicesLogic = AddIndicesLogic;