"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateEngine = exports.UpdateEngineApiLogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateEngine = async ({
  engineName,
  indices
}) => {
  const route = `/internal/enterprise_search/engines/${engineName}`;
  return await _http.HttpLogic.values.http.put(route, {
    body: JSON.stringify({
      indices,
      name: engineName
    })
  });
};
exports.updateEngine = updateEngine;
const UpdateEngineApiLogic = (0, _create_api_logic.createApiLogic)(['update_engine_api_logic'], updateEngine);
exports.UpdateEngineApiLogic = UpdateEngineApiLogic;