"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchEngines = exports.FetchEnginesAPILogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchEngines = async ({
  meta,
  searchQuery
}) => {
  const route = '/internal/enterprise_search/engines';
  const query = {
    from: meta.from,
    size: meta.size,
    ...(searchQuery && searchQuery.trim() !== '' ? {
      q: searchQuery + '*'
    } : {})
  };
  const response = await _http.HttpLogic.values.http.get(route, {
    query
  });
  return {
    ...response,
    params: query
  };
};
exports.fetchEngines = fetchEngines;
const FetchEnginesAPILogic = (0, _create_api_logic.createApiLogic)(['content', 'engines_api_logic'], fetchEngines);
exports.FetchEnginesAPILogic = FetchEnginesAPILogic;