"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchEngineFieldCapabilities = exports.FetchEngineFieldCapabilitiesApiLogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchEngineFieldCapabilities = async ({
  engineName
}) => {
  const route = `/internal/enterprise_search/engines/${engineName}/field_capabilities`;
  return await _http.HttpLogic.values.http.get(route);
};
exports.fetchEngineFieldCapabilities = fetchEngineFieldCapabilities;
const FetchEngineFieldCapabilitiesApiLogic = (0, _create_api_logic.createApiLogic)(['fetch_engine_field_capabilities_api_logic'], fetchEngineFieldCapabilities);
exports.FetchEngineFieldCapabilitiesApiLogic = FetchEngineFieldCapabilitiesApiLogic;