"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchEngine = exports.FetchEngineApiLogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchEngine = async ({
  engineName
}) => {
  const route = `/internal/enterprise_search/engines/${engineName}`;
  return await _http.HttpLogic.values.http.get(route);
};
exports.fetchEngine = fetchEngine;
const FetchEngineApiLogic = (0, _create_api_logic.createApiLogic)(['fetch_engine_api_logic'], fetchEngine);
exports.FetchEngineApiLogic = FetchEngineApiLogic;