"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteEngine = exports.DeleteEngineAPILogic = void 0;
var _i18n = require("@kbn/i18n");
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteEngine = async ({
  engineName
}) => {
  const route = `/internal/enterprise_search/engines/${engineName}`;
  await _http.HttpLogic.values.http.delete(route);
  return {
    engineName
  };
};
exports.deleteEngine = deleteEngine;
const DeleteEngineAPILogic = (0, _create_api_logic.createApiLogic)(['content', 'delete_engine_api_logic'], deleteEngine, {
  showSuccessFlashFn: ({
    engineName
  }) => _i18n.i18n.translate('xpack.enterpriseSearch.content.engineList.deleteEngine.successToast.title', {
    defaultMessage: '{engineName} has been deleted',
    values: {
      engineName
    }
  })
});
exports.DeleteEngineAPILogic = DeleteEngineAPILogic;