"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPDATE_SUCCESS = exports.SYNONYM_UPDATE_TITLE = exports.SYNONYM_IMPACT_MESSAGE = exports.SYNONYM_CREATE_TITLE = exports.SYNONYMS_TITLE = exports.SYNONYMS_PAGE_META = exports.DELETE_SUCCESS = exports.DELETE_CONFIRMATION = exports.CREATE_SUCCESS = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../../../shared/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SYNONYMS_PAGE_META = {
  page: {
    ..._constants.DEFAULT_META.page,
    size: 12 // Use a multiple of 3, since synonym cards are in rows of 3
  }
};
exports.SYNONYMS_PAGE_META = SYNONYMS_PAGE_META;
const SYNONYMS_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.synonyms.title', {
  defaultMessage: 'Synonyms'
});
exports.SYNONYMS_TITLE = SYNONYMS_TITLE;
const SYNONYM_CREATE_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.synonyms.createSynonymSetTitle', {
  defaultMessage: 'Add a synonym set'
});
exports.SYNONYM_CREATE_TITLE = SYNONYM_CREATE_TITLE;
const SYNONYM_UPDATE_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.synonyms.updateSynonymSetTitle', {
  defaultMessage: 'Manage synonym set'
});
exports.SYNONYM_UPDATE_TITLE = SYNONYM_UPDATE_TITLE;
const CREATE_SUCCESS = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.synonyms.createSuccessMessage', {
  defaultMessage: 'Synonym set created'
});
exports.CREATE_SUCCESS = CREATE_SUCCESS;
const UPDATE_SUCCESS = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.synonyms.updateSuccessMessage', {
  defaultMessage: 'Synonym set updated'
});
exports.UPDATE_SUCCESS = UPDATE_SUCCESS;
const DELETE_CONFIRMATION = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.synonyms.deleteConfirmationMessage', {
  defaultMessage: 'Are you sure you want to delete this synonym set?'
});
exports.DELETE_CONFIRMATION = DELETE_CONFIRMATION;
const DELETE_SUCCESS = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.synonyms.deleteSuccessMessage', {
  defaultMessage: 'Synonym set deleted'
});
exports.DELETE_SUCCESS = DELETE_SUCCESS;
const SYNONYM_IMPACT_MESSAGE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.synonyms.impactDescription', {
  defaultMessage: 'The set will impact your results shortly.'
});
exports.SYNONYM_IMPACT_MESSAGE = SYNONYM_IMPACT_MESSAGE;