"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceEngines = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _app_logic = require("../../app_logic");
var _engine = require("../engine");
var _layout = require("../layout");
var _components = require("./components");
var _i18n = require("./i18n");
var _source_engines_logic = require("./source_engines_logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SourceEngines = () => {
  const {
    myRole: {
      canManageMetaEngineSourceEngines
    }
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const {
    fetchIndexedEngines,
    fetchSourceEngines
  } = (0, _kea.useActions)(_source_engines_logic.SourceEnginesLogic);
  const {
    dataLoading,
    isModalOpen
  } = (0, _kea.useValues)(_source_engines_logic.SourceEnginesLogic);
  (0, _react.useEffect)(() => {
    fetchIndexedEngines();
    fetchSourceEngines();
  }, []);
  return /*#__PURE__*/_react.default.createElement(_layout.AppSearchPageTemplate, {
    pageChrome: (0, _engine.getEngineBreadcrumbs)([_i18n.SOURCE_ENGINES_TITLE]),
    pageHeader: {
      pageTitle: _i18n.SOURCE_ENGINES_TITLE,
      rightSideItems: canManageMetaEngineSourceEngines ? [/*#__PURE__*/_react.default.createElement(_components.AddSourceEnginesButton, null)] : []
    },
    isLoading: dataLoading
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_components.SourceEnginesTable, null), isModalOpen && /*#__PURE__*/_react.default.createElement(_components.AddSourceEnginesModal, null)));
};
exports.SourceEngines = SourceEngines;