"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.URL_FIELD_LABEL = exports.URL_FIELD_HELP_TEXT = exports.TITLE_FIELD_LABEL = exports.TITLE_FIELD_HELP_TEXT = exports.THUMBNAIL_FIELD_LABEL = exports.THUMBNAIL_FIELD_HELP_TEXT = exports.SORT_FIELD_LABEL = exports.SORT_FIELD_HELP_TEXT = exports.SEARCH_UI_TITLE = exports.NO_SEARCH_KEY_ERROR = exports.GENERATE_PREVIEW_BUTTON_LABEL = exports.FILTER_FIELD_LABEL = exports.FILTER_FIELD_HELP_TEXT = void 0;
var _i18n = require("@kbn/i18n");
var _credentials = require("../credentials");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SEARCH_UI_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.searchUI.title', {
  defaultMessage: 'Search UI'
});
exports.SEARCH_UI_TITLE = SEARCH_UI_TITLE;
const TITLE_FIELD_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.searchUI.titleFieldLabel', {
  defaultMessage: 'Title field (Optional)'
});
exports.TITLE_FIELD_LABEL = TITLE_FIELD_LABEL;
const TITLE_FIELD_HELP_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.searchUI.titleFieldHelpText', {
  defaultMessage: 'Used as the top-level visual identifier for every rendered result'
});
exports.TITLE_FIELD_HELP_TEXT = TITLE_FIELD_HELP_TEXT;
const FILTER_FIELD_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.searchUI.filterFieldLabel', {
  defaultMessage: 'Filter fields (Optional)'
});
exports.FILTER_FIELD_LABEL = FILTER_FIELD_LABEL;
const FILTER_FIELD_HELP_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.searchUI.filterFieldHelpText', {
  defaultMessage: 'Faceted values rendered as filters and available as query refinement'
});
exports.FILTER_FIELD_HELP_TEXT = FILTER_FIELD_HELP_TEXT;
const SORT_FIELD_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.searchUI.sortFieldLabel', {
  defaultMessage: 'Sort fields (Optional)'
});
exports.SORT_FIELD_LABEL = SORT_FIELD_LABEL;
const SORT_FIELD_HELP_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.searchUI.sortHelpText', {
  defaultMessage: 'Used to display result sorting options, ascending and descending'
});
exports.SORT_FIELD_HELP_TEXT = SORT_FIELD_HELP_TEXT;
const URL_FIELD_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.searchUI.urlFieldLabel', {
  defaultMessage: 'URL field (Optional)'
});
exports.URL_FIELD_LABEL = URL_FIELD_LABEL;
const THUMBNAIL_FIELD_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.searchUI.thumbnailFieldLabel', {
  defaultMessage: 'Thumbnail field (Optional)'
});
exports.THUMBNAIL_FIELD_LABEL = THUMBNAIL_FIELD_LABEL;
const URL_FIELD_HELP_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.searchUI.urlFieldHelpText', {
  defaultMessage: "Used as a result's link target, if applicable"
});
exports.URL_FIELD_HELP_TEXT = URL_FIELD_HELP_TEXT;
const THUMBNAIL_FIELD_HELP_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.searchUI.thumbnailFieldHelpText', {
  defaultMessage: 'Provide an image URL to show a thumbnail image'
});
exports.THUMBNAIL_FIELD_HELP_TEXT = THUMBNAIL_FIELD_HELP_TEXT;
const GENERATE_PREVIEW_BUTTON_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.searchUI.generatePreviewButtonLabel', {
  defaultMessage: 'Generate search experience'
});
exports.GENERATE_PREVIEW_BUTTON_LABEL = GENERATE_PREVIEW_BUTTON_LABEL;
const NO_SEARCH_KEY_ERROR = engineName => _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.searchUI.noSearchKeyErrorMessage', {
  defaultMessage: "It looks like you don't have any Public Search Keys with access to the '{engineName}' engine. Please visit the {credentialsTitle} page to set one up.",
  values: {
    engineName,
    credentialsTitle: _credentials.CREDENTIALS_TITLE
  }
});
exports.NO_SEARCH_KEY_ERROR = NO_SEARCH_KEY_ERROR;