"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SchemaBaseLogic = void 0;
var _kea = require("kea");
var _flash_messages = require("../../../shared/flash_messages");
var _http = require("../../../shared/http");
var _engine = require("../engine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SchemaBaseLogic = (0, _kea.kea)({
  path: ['enterprise_search', 'app_search', 'schema_base_logic'],
  actions: {
    loadSchema: true,
    onSchemaLoad: response => response,
    setSchema: schema => ({
      schema
    })
  },
  reducers: {
    dataLoading: [true, {
      loadSchema: () => true,
      onSchemaLoad: () => false
    }],
    schema: [{}, {
      onSchemaLoad: (_, {
        schema
      }) => schema,
      setSchema: (_, {
        schema
      }) => schema
    }]
  },
  listeners: ({
    actions
  }) => ({
    loadSchema: async () => {
      const {
        http
      } = _http.HttpLogic.values;
      const {
        engineName
      } = _engine.EngineLogic.values;
      try {
        const response = await http.get(`/internal/app_search/engines/${engineName}/schema`);
        actions.onSchemaLoad(response);
      } catch (e) {
        (0, _flash_messages.flashAPIErrors)(e);
      }
    }
  })
});
exports.SchemaBaseLogic = SchemaBaseLogic;