"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SampleEngineCreationCta = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("./i18n");
var _sample_engine_creation_cta_logic = require("./sample_engine_creation_cta_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SampleEngineCreationCta = () => {
  const {
    isLoading
  } = (0, _kea.useValues)(_sample_engine_creation_cta_logic.SampleEngineCreationCtaLogic);
  const {
    createSampleEngine
  } = (0, _kea.useActions)(_sample_engine_creation_cta_logic.SampleEngineCreationCtaLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "eui-textLeft eui-textNoWrap"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.SAMPLE_ENGINE_CREATION_CTA_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.SAMPLE_ENGINE_CREATION_CTA_DESCRIPTION))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: createSampleEngine,
    isLoading: isLoading
  }, _i18n.SAMPLE_ENGINE_CREATION_CTA_BUTTON_LABEL))));
};
exports.SampleEngineCreationCta = SampleEngineCreationCta;