"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EngineAssignmentSelector = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _role_mapping = require("../../../shared/role_mapping");
var _has_scoped_engines = require("../../utils/role/has_scoped_engines");
var _constants = require("./constants");
var _role_mappings_logic = require("./role_mappings_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EngineAssignmentSelector = () => {
  const {
    handleAccessAllEnginesChange,
    handleEngineSelectionChange
  } = (0, _kea.useActions)(_role_mappings_logic.RoleMappingsLogic);
  const {
    accessAllEngines,
    availableEngines,
    roleType,
    selectedEngines,
    selectedOptions
  } = (0, _kea.useValues)(_role_mappings_logic.RoleMappingsLogic);
  const hasEngineAssignment = selectedEngines.size > 0 || accessAllEngines;
  const engineOptions = [{
    id: 'all',
    label: /*#__PURE__*/_react.default.createElement(_role_mapping.RoleOptionLabel, {
      label: _constants.ALL_ENGINES_LABEL,
      description: _constants.ALL_ENGINES_DESCRIPTION
    })
  }, {
    id: 'specific',
    label: /*#__PURE__*/_react.default.createElement(_role_mapping.RoleOptionLabel, {
      label: _constants.SPECIFIC_ENGINES_LABEL,
      description: _constants.SPECIFIC_ENGINES_DESCRIPTION
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    options: engineOptions,
    disabled: !(0, _has_scoped_engines.roleHasScopedEngines)(roleType),
    idSelected: accessAllEngines ? 'all' : 'specific',
    onChange: id => handleAccessAllEnginesChange(id === 'all'),
    legend: {
      children: /*#__PURE__*/_react.default.createElement("span", null, _constants.ENGINE_ASSIGNMENT_LABEL)
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: !hasEngineAssignment,
    error: [_constants.ENGINE_REQUIRED_ERROR]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "enginesSelect",
    selectedOptions: selectedOptions,
    options: availableEngines.map(({
      name
    }) => ({
      label: name,
      value: name
    })),
    onChange: options => {
      handleEngineSelectionChange(options.map(({
        value
      }) => value));
    },
    fullWidth: true,
    isDisabled: accessAllEngines || !(0, _has_scoped_engines.roleHasScopedEngines)(roleType)
  })));
};
exports.EngineAssignmentSelector = EngineAssignmentSelector;