"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SampleResponseLogic = void 0;
var _kea = require("kea");
var _i18n = require("@kbn/i18n");
var _flash_messages = require("../../../../shared/flash_messages");
var _http = require("../../../../shared/http");
var _engine = require("../../engine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NO_RESULTS_MESSAGE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.resultSettings.sampleResponse.noResultsMessage', {
  defaultMessage: 'No results.'
});
const ERROR_MESSAGE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.resultSettings.sampleResponse.errorMessage', {
  defaultMessage: 'An error occured.'
});
const SampleResponseLogic = (0, _kea.kea)({
  path: ['enterprise_search', 'app_search', 'sample_response_logic'],
  actions: {
    queryChanged: query => ({
      query
    }),
    getSearchResultsSuccess: response => ({
      response
    }),
    getSearchResultsFailure: response => ({
      response
    }),
    getSearchResults: (query, resultFields) => ({
      query,
      resultFields
    })
  },
  reducers: {
    query: ['', {
      queryChanged: (_, {
        query
      }) => query
    }],
    response: [null, {
      getSearchResultsSuccess: (_, {
        response
      }) => response,
      getSearchResultsFailure: (_, {
        response
      }) => response
    }]
  },
  listeners: ({
    actions
  }) => ({
    getSearchResults: async ({
      query,
      resultFields
    }, breakpoint) => {
      await breakpoint(250);
      const {
        http
      } = _http.HttpLogic.values;
      const {
        engineName
      } = _engine.EngineLogic.values;
      const url = `/internal/app_search/engines/${engineName}/search`;
      try {
        var _response$results;
        const response = await http.post(url, {
          query: {
            query
          },
          body: JSON.stringify({
            page: {
              size: 1,
              current: 1
            },
            result_fields: resultFields
          })
        });
        const result = (_response$results = response.results) === null || _response$results === void 0 ? void 0 : _response$results[0];
        actions.getSearchResultsSuccess(
        // @ts-expect-error TS2345
        result ? {
          ...result,
          _meta: undefined
        } : NO_RESULTS_MESSAGE);
      } catch (e) {
        if (e.response.status >= 500) {
          // 4XX Validation errors are expected, as a user could enter something like 2 as a size, which is out of valid range.
          // In this case, we simply render the message from the server as the response.
          //
          // 5xx Server errors are unexpected, and need to be reported in a flash message.
          (0, _flash_messages.flashAPIErrors)(e);
          actions.getSearchResultsFailure(ERROR_MESSAGE);
        } else {
          var _e$body;
          actions.getSearchResultsFailure(((_e$body = e.body) === null || _e$body === void 0 ? void 0 : _e$body.attributes) || ERROR_MESSAGE);
        }
      }
    }
  })
});
exports.SampleResponseLogic = SampleResponseLogic;