"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Boosts = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _types = require("../../../../shared/schema/types");
var _components = require("../components");
var _constants = require("../constants");
var _relevance_tuning_logic = require("../relevance_tuning_logic");
var _types2 = require("../types");
var _boost_item = require("./boost_item");
require("./boosts.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BASE_OPTIONS = [{
  value: 'add-boost',
  inputDisplay: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.boosts.addBoostDropDownOptionLabel', {
    defaultMessage: 'Add boost'
  }),
  disabled: true
}, {
  value: _types2.BoostType.Functional,
  inputDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_components.BoostIcon, {
    type: _types2.BoostType.Functional
  }), _constants.FUNCTIONAL_DISPLAY)
}, {
  value: _types2.BoostType.Proximity,
  inputDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_components.BoostIcon, {
    type: _types2.BoostType.Proximity
  }), _constants.PROXIMITY_DISPLAY)
}, {
  value: _types2.BoostType.Value,
  inputDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_components.BoostIcon, {
    type: _types2.BoostType.Value
  }), _constants.VALUE_DISPLAY)
}];
const filterInvalidOptions = (value, type) => {
  // Proximity and Functional boost types are not valid for text fields
  if (type === _types.SchemaType.Text && [_types2.BoostType.Proximity, _types2.BoostType.Functional].includes(value)) return false;
  // Value and Functional boost types are not valid for geolocation fields
  if (type === _types.SchemaType.Geolocation && [_types2.BoostType.Functional, _types2.BoostType.Value].includes(value)) return false;
  // Functional boosts are not valid for date fields
  if (type === _types.SchemaType.Date && value === _types2.BoostType.Functional) return false;
  return true;
};
const Boosts = ({
  name,
  type,
  boosts = []
}) => {
  const {
    addBoost
  } = (0, _kea.useActions)(_relevance_tuning_logic.RelevanceTuningLogic);
  const selectOptions = (0, _react.useMemo)(() => BASE_OPTIONS.filter(option => filterInvalidOptions(option.value, type)), [type]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    className: "boosts"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.boosts.title', {
    defaultMessage: 'Boosts'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    className: "boosts__select",
    itemClassName: "boostSelectOption",
    valueOfSelected: 'add-boost',
    options: selectOptions,
    onChange: value => addBoost(name, value)
  }))), boosts.map((boost, index) => /*#__PURE__*/_react.default.createElement(_boost_item.BoostItem, {
    key: index,
    id: `boost-${name}-${index}`,
    boost: boost,
    name: name,
    index: index
  })));
};
exports.Boosts = Boosts;