"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Library = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _kibana_chrome = require("../../../shared/kibana_chrome");
var _types = require("../../../shared/schema/types");
var _inline_editable_table = require("../../../shared/tables/inline_editable_table");
var _reorderable_table = require("../../../shared/tables/reorderable_table");
var _result = require("../result");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* istanbul ignore file */

const NO_ITEMS = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  iconType: "clock",
  title: /*#__PURE__*/_react.default.createElement("h2", null, "No Items"),
  body: /*#__PURE__*/_react.default.createElement("p", null, "No Items")
});

// For the InlineEditableTable
// Since InlineEditableTable caches handlers, we need to store this globally somewhere rather than just in useState

let globalItems = [];
const getLastItems = () => globalItems;
const Library = () => {
  const props = {
    isMetaEngine: false,
    result: {
      id: {
        raw: '1'
      },
      _meta: {
        id: '1',
        score: 100,
        engine: 'my-engine'
      },
      title: {
        raw: 'A title'
      },
      description: {
        raw: 'A description'
      },
      date_established: {
        raw: '1968-10-02T05:00:00Z'
      },
      location: {
        raw: '37.3,-113.05'
      },
      visitors: {
        raw: 1000
      },
      states: {
        raw: ['Pennsylvania', 'Ohio']
      },
      size: {
        raw: 200
      },
      length: {
        raw: 100
      }
    }
  };
  const schema = {
    title: _types.SchemaType.Text,
    description: _types.SchemaType.Text,
    date_established: _types.SchemaType.Date,
    location: _types.SchemaType.Geolocation,
    states: _types.SchemaType.Text,
    visitors: _types.SchemaType.Number,
    size: _types.SchemaType.Number,
    length: _types.SchemaType.Number
  };
  const [isActionButtonFilled, setIsActionButtonFilled] = (0, _react.useState)(false);
  const actions = [{
    title: 'Fill this action button',
    onClick: () => setIsActionButtonFilled(!isActionButtonFilled),
    iconType: isActionButtonFilled ? 'starFilled' : 'starEmpty',
    iconColor: 'primary'
  }];

  // For the InlineEditableTable
  const [items, setItems] = (0, _react.useState)([{
    id: 1,
    foo: 'foo1',
    bar: '10'
  }, {
    id: 2,
    foo: 'foo2',
    bar: '10'
  }]);
  globalItems = items;
  const columns = [{
    field: 'foo',
    name: 'Foo',
    render: item => /*#__PURE__*/_react.default.createElement("div", null, item.foo),
    editingRender: (item, onChange) => /*#__PURE__*/_react.default.createElement("input", {
      type: "text",
      value: item.foo,
      onChange: e => onChange(e.target.value)
    })
  }, {
    field: 'bar',
    name: 'Bar (Must be a number)',
    render: item => /*#__PURE__*/_react.default.createElement("div", null, item.bar),
    editingRender: (item, onChange) => /*#__PURE__*/_react.default.createElement("input", {
      type: "text",
      value: item.bar,
      onChange: e => onChange(e.target.value)
    })
  }];
  const onAdd = (item, onSuccess) => {
    const highestId = Math.max(...getLastItems().map(i => i.id));
    setItems([...getLastItems(), {
      ...item,
      id: highestId + 1
    }]);
    onSuccess();
  };
  const onDelete = item => {
    setItems(getLastItems().filter(i => i.id !== item.id));
  };
  const onUpdate = (item, onSuccess) => {
    setItems(getLastItems().map(i => {
      if (item.id === i.id) return item;
      return i;
    }));
    onSuccess();
  };
  const validateItem = item => {
    let isValidNumber = false;
    const num = parseInt(item.bar, 10);
    if (!isNaN(num)) isValidNumber = true;
    if (isValidNumber) return {};
    return {
      bar: 'Bar must be a valid number'
    };
  };
  const onReorder = newItems => {
    setItems(newItems);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_kibana_chrome.SetAppSearchChrome, {
    trail: ['Library']
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: "Library"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageContent_Deprecated, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageContentBody_Deprecated, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, "Result")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, "5 or more fields")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_result.Result, props), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, "5 or less fields")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_result.Result, (0, _extends2.default)({}, props, {
    result: {
      id: props.result.id,
      _meta: props.result._meta,
      title: props.result.title,
      description: props.result.description
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, "With just an id")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_result.Result, (0, _extends2.default)({}, props, {
    result: {
      ...props.result,
      _meta: {
        id: '1',
        score: 100,
        engine: 'my-engine'
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, "With an id and a score")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_result.Result, (0, _extends2.default)({}, props, {
    showScore: true,
    result: {
      ...props.result,
      _meta: {
        id: '1',
        score: 100,
        engine: 'my-engine'
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, "With a document position")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_result.Result, (0, _extends2.default)({}, props, {
    resultPosition: 3,
    result: {
      ...props.result,
      _meta: {
        id: '1',
        score: 100,
        engine: 'my-engine'
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, "With an id and a score and an engine")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_result.Result, (0, _extends2.default)({}, props, {
    isMetaEngine: true,
    showScore: true,
    result: {
      ...props.result,
      _meta: {
        id: '1',
        score: 100,
        engine: 'my-engine'
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, "With a long id, a long engine name, a long field key, and a long value")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_result.Result, (0, _extends2.default)({}, props, {
    isMetaEngine: true,
    result: {
      ...props.result,
      'this-description-is-a-really-really-really-really-really-really-really-really-really-really-really-really-really-really-really-really-really-really-really-really-really-really-really-really-long-key': {
        raw: 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?'
      },
      _meta: {
        id: 'my-id-is-a-really-long-id-yes-it-is',
        score: 100,
        engine: 'my-engine-is-a-really-long-engin-name-yes-it-is'
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, "With a link")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_result.Result, (0, _extends2.default)({}, props, {
    shouldLinkToDetailPage: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, "With custom actions")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_result.Result, (0, _extends2.default)({}, props, {
    actions: actions
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, "With custom actions and a link")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_result.Result, (0, _extends2.default)({}, props, {
    actions: actions,
    shouldLinkToDetailPage: true,
    showScore: true,
    isMetaEngine: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, "With a drag handle")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiDragDropContext, {
    onDragEnd: () => {}
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDroppable, {
    spacing: "m",
    droppableId: "DraggableResultsTest"
  }, [1, 2, 3].map((_, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiDraggable, {
    spacing: "m",
    key: `draggable-${i}`,
    index: i,
    draggableId: `draggable-${i}`,
    customDragHandle: true
  }, provided => /*#__PURE__*/_react.default.createElement(_result.Result, (0, _extends2.default)({}, props, {
    dragHandleProps: provided.dragHandleProps
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, "With field value type highlights")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_result.Result, (0, _extends2.default)({}, props, {
    schemaForTypeHighlights: schema
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, "ReorderableTable")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_reorderable_table.ReorderableTable, {
    noItemsMessage: NO_ITEMS,
    items: [{
      id: 1
    }, {
      id: 2
    }, {
      id: 3
    }],
    columns: [{
      name: 'ID',
      render: item => /*#__PURE__*/_react.default.createElement("div", null, item.id)
    }, {
      name: 'Whatever',
      render: () => /*#__PURE__*/_react.default.createElement("div", null, "Whatever")
    }]
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, "With reordering disabled")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_reorderable_table.ReorderableTable, {
    disableReordering: true,
    noItemsMessage: NO_ITEMS,
    items: [{
      id: 1
    }, {
      id: 2
    }, {
      id: 3
    }],
    columns: [{
      name: 'ID',
      render: item => /*#__PURE__*/_react.default.createElement("div", null, item.id)
    }, {
      name: 'Whatever',
      render: () => /*#__PURE__*/_react.default.createElement("div", null, "Whatever")
    }]
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, "With reordering enabled, but dragging disabled")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_reorderable_table.ReorderableTable, {
    disableDragging: true,
    noItemsMessage: NO_ITEMS,
    items: [{
      id: 1
    }, {
      id: 2
    }, {
      id: 3
    }],
    columns: [{
      name: 'ID',
      render: item => /*#__PURE__*/_react.default.createElement("div", null, item.id)
    }, {
      name: 'Whatever',
      render: () => /*#__PURE__*/_react.default.createElement("div", null, "Whatever")
    }]
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, "With unreorderable items")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_reorderable_table.ReorderableTable, {
    noItemsMessage: NO_ITEMS,
    items: [{
      id: 1
    }, {
      id: 2
    }, {
      id: 3
    }],
    unreorderableItems: [{
      id: 4
    }, {
      id: 5
    }],
    columns: [{
      name: 'ID',
      render: item => /*#__PURE__*/_react.default.createElement("div", null, item.id)
    }, {
      name: 'Whatever',
      render: () => /*#__PURE__*/_react.default.createElement("div", null, "Whatever")
    }]
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, "Using the rowProps prop to apply dynamic properties to each row")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_reorderable_table.ReorderableTable, {
    rowProps: item => ({
      style: {
        backgroundColor: item.id % 2 === 0 ? 'red' : 'green'
      }
    }),
    noItemsMessage: NO_ITEMS,
    items: [{
      id: 1
    }, {
      id: 2
    }, {
      id: 3
    }],
    columns: [{
      name: 'ID',
      render: item => /*#__PURE__*/_react.default.createElement("div", null, item.id)
    }, {
      name: 'Whatever',
      render: () => /*#__PURE__*/_react.default.createElement("div", null, "Whatever")
    }]
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, "With no items")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_reorderable_table.ReorderableTable, {
    noItemsMessage: NO_ITEMS,
    items: [],
    columns: [{
      name: 'ID',
      render: item => /*#__PURE__*/_react.default.createElement("div", null, item.id)
    }, {
      name: 'Whatever',
      render: () => /*#__PURE__*/_react.default.createElement("div", null, "Whatever")
    }]
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, "InlineEditableTable")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, "With uneditable items")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_inline_editable_table.InlineEditableTable, {
    items: items,
    uneditableItems: [{
      id: 3,
      foo: 'foo',
      bar: 'bar'
    }],
    instanceId: "MyInstance",
    title: "My table",
    description: "Some description",
    columns: columns,
    onAdd: onAdd,
    onDelete: onDelete,
    onUpdate: onUpdate,
    validateItem: validateItem,
    onReorder: onReorder
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, "Can delete last item")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_inline_editable_table.InlineEditableTable, {
    items: items,
    instanceId: "MyInstance1",
    title: "My table",
    description: "Some description",
    columns: columns,
    onAdd: onAdd,
    onDelete: onDelete,
    onUpdate: onUpdate,
    validateItem: validateItem,
    onReorder: onReorder,
    canRemoveLastItem: true,
    noItemsMessage: edit => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
        iconType: "clock",
        title: /*#__PURE__*/_react.default.createElement("h2", null, "No Items"),
        body: /*#__PURE__*/_react.default.createElement("button", {
          onClick: edit
        }, "Click to create one")
      });
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, "Cannot delete last item")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_inline_editable_table.InlineEditableTable, {
    items: items,
    instanceId: "MyInstance2",
    title: "My table",
    description: "Some description",
    columns: columns,
    onAdd: onAdd,
    onDelete: onDelete,
    onUpdate: onUpdate,
    validateItem: validateItem,
    onReorder: onReorder,
    canRemoveLastItem: false,
    lastItemWarning: "This is the last item, you cannot delete it!"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, "When isLoading is true")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_inline_editable_table.InlineEditableTable, {
    isLoading: true,
    items: items,
    instanceId: "MyInstance3",
    title: "My table",
    description: "Some description",
    columns: columns,
    onAdd: onAdd,
    onDelete: onDelete,
    onUpdate: onUpdate,
    validateItem: validateItem,
    onReorder: onReorder
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null))));
};
exports.Library = Library;