"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SOURCE_ENGINES_TITLE = exports.META_ENGINES_TITLE = exports.ENGINES_TITLE = exports.ENGINES_OVERVIEW_TITLE = exports.DELETE_ENGINE_MESSAGE = exports.CREATE_A_META_ENGINE_BUTTON_LABEL = exports.CREATE_AN_ENGINE_BUTTON_LABEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ENGINES_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engines.title', {
  defaultMessage: 'Engines'
});
exports.ENGINES_TITLE = ENGINES_TITLE;
const ENGINES_OVERVIEW_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.enginesOverview.title', {
  defaultMessage: 'Engines overview'
});
exports.ENGINES_OVERVIEW_TITLE = ENGINES_OVERVIEW_TITLE;
const META_ENGINES_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.metaEngines.title', {
  defaultMessage: 'Meta Engines'
});
exports.META_ENGINES_TITLE = META_ENGINES_TITLE;
const SOURCE_ENGINES_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.enginesOverview.metaEnginesTable.sourceEngines.title', {
  defaultMessage: 'Source Engines'
});
exports.SOURCE_ENGINES_TITLE = SOURCE_ENGINES_TITLE;
const CREATE_AN_ENGINE_BUTTON_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engines.createEngineButtonLabel', {
  defaultMessage: 'Create engine'
});
exports.CREATE_AN_ENGINE_BUTTON_LABEL = CREATE_AN_ENGINE_BUTTON_LABEL;
const CREATE_A_META_ENGINE_BUTTON_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engines.createMetaEngineButtonLabel', {
  defaultMessage: 'Create meta engine'
});
exports.CREATE_A_META_ENGINE_BUTTON_LABEL = CREATE_A_META_ENGINE_BUTTON_LABEL;
const DELETE_ENGINE_MESSAGE = engineName => _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.enginesOverview.table.action.delete.successMessage', {
  defaultMessage: "Engine '{engineName}' was deleted",
  values: {
    engineName
  }
});
exports.DELETE_ENGINE_MESSAGE = DELETE_ENGINE_MESSAGE;