"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetaEnginesTableLogic = void 0;
var _kea = require("kea");
var _recursively_fetch_engines = require("../../../../utils/recursively_fetch_engines");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetaEnginesTableLogic = (0, _kea.kea)({
  path: ['enterprise_search', 'app_search', 'meta_engines_table_logic'],
  actions: () => ({
    addSourceEngines: sourceEngines => ({
      sourceEngines
    }),
    displayRow: itemId => ({
      itemId
    }),
    hideRow: itemId => ({
      itemId
    }),
    fetchOrDisplayRow: itemId => ({
      itemId
    }),
    fetchSourceEngines: engineName => ({
      engineName
    })
  }),
  reducers: () => ({
    expandedRows: [{}, {
      displayRow: (expandedRows, {
        itemId
      }) => ({
        ...expandedRows,
        [itemId]: true
      }),
      hideRow: (expandedRows, {
        itemId
      }) => {
        const newRows = {
          ...expandedRows
        };
        delete newRows[itemId];
        return newRows;
      }
    }],
    sourceEngines: [{}, {
      addSourceEngines: (currentSourceEngines, {
        sourceEngines: newSourceEngines
      }) => ({
        ...currentSourceEngines,
        ...newSourceEngines
      })
    }]
  }),
  selectors: {
    expandedSourceEngines: [selectors => [selectors.sourceEngines, selectors.expandedRows], (sourceEngines, expandedRows) => {
      return Object.keys(expandedRows).reduce((expandedRowMap, engineName) => {
        expandedRowMap[engineName] = sourceEngines[engineName];
        return expandedRowMap;
      }, {});
    }]
  },
  listeners: ({
    actions,
    values
  }) => ({
    fetchOrDisplayRow: ({
      itemId
    }) => {
      const sourceEngines = values.sourceEngines;
      if (sourceEngines[itemId]) {
        actions.displayRow(itemId);
      } else {
        actions.fetchSourceEngines(itemId);
      }
    },
    fetchSourceEngines: ({
      engineName
    }) => {
      (0, _recursively_fetch_engines.recursivelyFetchEngines)({
        endpoint: `/internal/app_search/engines/${engineName}/source_engines`,
        onComplete: sourceEngines => {
          actions.addSourceEngines({
            [engineName]: sourceEngines
          });
          actions.displayRow(engineName);
        }
      });
    }
  })
});
exports.MetaEnginesTableLogic = MetaEnginesTableLogic;