"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigureAppSearchEngine = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("./constants");
var _engine_creation_logic = require("./engine_creation_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfigureAppSearchEngine = () => {
  const {
    isSubmitDisabled,
    language,
    name,
    rawName
  } = (0, _kea.useValues)(_engine_creation_logic.EngineCreationLogic);
  const {
    setCreationStep,
    setLanguage,
    setRawName,
    submitEngine
  } = (0, _kea.useActions)(_engine_creation_logic.EngineCreationLogic);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "entSearch__createEngineLayout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStepsHorizontal, {
    steps: [{
      onClick: () => setCreationStep(_engine_creation_logic.EngineCreationSteps.SelectStep),
      status: 'complete',
      title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.steps.searchEngineType.label', {
        defaultMessage: 'Search engine type'
      })
    }, {
      onClick: () => {},
      status: 'current',
      title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.steps.configuration.label', {
        defaultMessage: 'Configuration'
      })
    }, {
      onClick: () => {},
      status: 'disabled',
      title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.steps.finish.label', {
        defaultMessage: 'Finish'
      })
    }]
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    "data-test-subj": "EngineCreationForm",
    onSubmit: e => {
      e.preventDefault();
      submitEngine();
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
    textAlign: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, _constants.ENGINE_CREATION_FORM_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    textAlign: "center"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.configureForm.appSearch.description', {
    defaultMessage: 'Provide a unique name and an optional language choice for your App Search engine.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "EngineCreationNameFormRow",
    label: _constants.ENGINE_CREATION_FORM_ENGINE_NAME_LABEL,
    helpText: name.length > 0 && rawName !== name ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _constants.SANITIZED_NAME_NOTE, " ", /*#__PURE__*/_react.default.createElement("strong", null, name)) : _constants.ALLOWED_CHARS_NOTE,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "engine-name",
    value: rawName,
    onChange: event => setRawName(event.currentTarget.value),
    autoComplete: "off",
    fullWidth: true,
    "data-test-subj": "EngineCreationNameInput",
    placeholder: _constants.ENGINE_CREATION_FORM_ENGINE_NAME_PLACEHOLDER,
    autoFocus: true
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _constants.ENGINE_CREATION_FORM_ENGINE_LANGUAGE_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    name: "engine-language",
    value: language,
    options: _constants.SUPPORTED_LANGUAGES,
    "data-test-subj": "EngineCreationLanguageInput",
    onChange: event => setLanguage(event.currentTarget.value)
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "NewEngineBackButton",
    color: "primary",
    iconType: "arrowLeft",
    onClick: () => {
      setCreationStep(_engine_creation_logic.EngineCreationSteps.SelectStep);
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.form.backButton.label', {
    defaultMessage: 'Back'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: isSubmitDisabled,
    type: "submit",
    "data-test-subj": "NewEngineSubmitButton",
    iconType: "arrowRight",
    iconSide: "right",
    fill: true
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.form.continue.label', {
    defaultMessage: 'Create search engine'
  })))))));
};
exports.ConfigureAppSearchEngine = ConfigureAppSearchEngine;