"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEngineBreadcrumbs = exports.generateEnginePath = void 0;
var _encode_path_params = require("../../utils/encode_path_params");
var _engines = require("../engines");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Generate a path with engineName automatically filled from EngineLogic state
 */
const generateEnginePath = (path, pathParams = {}) => {
  const {
    engineName
  } = _.EngineLogic.values;
  return (0, _encode_path_params.generateEncodedPath)(path, {
    engineName,
    ...pathParams
  });
};

/**
 * Generate a breadcrumb trail with engineName automatically filled from EngineLogic state
 */
exports.generateEnginePath = generateEnginePath;
const getEngineBreadcrumbs = (breadcrumbs = []) => {
  const {
    engineName
  } = _.EngineLogic.values;
  return [_engines.ENGINES_TITLE, engineName, ...breadcrumbs];
};
exports.getEngineBreadcrumbs = getEngineBreadcrumbs;