"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchExperience = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _reactSearchUi = require("@elastic/react-search-ui");
var _searchUiAppSearchConnector = _interopRequireDefault(require("@elastic/search-ui-app-search-connector"));
var _i18n = require("@kbn/i18n");
require("./search_experience.scss");
var _http = require("../../../../shared/http");
var _use_local_storage = require("../../../../shared/use_local_storage");
var _engine = require("../../engine");
var _build_search_ui_config = require("./build_search_ui_config");
var _build_sort_options = require("./build_sort_options");
var _constants = require("./constants");
var _customization_callout = require("./customization_callout");
var _customization_modal = require("./customization_modal");
var _search_experience_content = require("./search_experience_content");
var _views = require("./views");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DOCUMENT_ID = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documents.search.sortBy.option.documentId', {
  defaultMessage: 'Document ID'
});
const RELEVANCE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documents.search.sortBy.option.relevance', {
  defaultMessage: 'Relevance'
});
const DEFAULT_SORT_OPTIONS = [{
  name: (0, _constants.DESCENDING)(DOCUMENT_ID),
  value: 'id',
  direction: 'desc'
}, {
  name: (0, _constants.ASCENDING)(DOCUMENT_ID),
  value: 'id',
  direction: 'asc'
}];
const RELEVANCE_SORT_OPTIONS = [{
  name: RELEVANCE,
  value: '_score',
  direction: 'desc'
}];
const SearchExperience = () => {
  const {
    engine
  } = (0, _kea.useValues)(_engine.EngineLogic);
  const {
    http
  } = (0, _kea.useValues)(_http.HttpLogic);
  const endpointBase = http.basePath.prepend('/internal/app_search/search-ui');
  const [showCustomizationModal, setShowCustomizationModal] = (0, _react.useState)(false);
  const openCustomizationModal = () => setShowCustomizationModal(true);
  const closeCustomizationModal = () => setShowCustomizationModal(false);
  const [fields, setFields] = (0, _use_local_storage.useLocalStorage)(`documents-search-experience-customization--${engine.name}`, {
    filterFields: [],
    sortFields: []
  });
  const useRelevance = engine.type === 'elasticsearch' || engine.type === 'meta';
  const sortOptions = useRelevance ? RELEVANCE_SORT_OPTIONS : DEFAULT_SORT_OPTIONS;
  const sortingOptions = (0, _build_sort_options.buildSortOptions)(fields, sortOptions);
  const connector = new _searchUiAppSearchConnector.default({
    cacheResponses: false,
    endpointBase,
    engineName: engine.name,
    additionalHeaders: {
      'kbn-xsrf': true
    }
  });
  const initialState = {
    sortField: sortOptions[0].value,
    sortDirection: 'desc'
  };
  const searchProviderConfig = (0, _build_search_ui_config.buildSearchUIConfig)(connector, engine.advancedSchema || {}, fields, initialState);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "documentsSearchExperience"
  }, /*#__PURE__*/_react.default.createElement(_reactSearchUi.SearchProvider, {
    config: searchProviderConfig
  }, /*#__PURE__*/_react.default.createElement(_reactSearchUi.SearchBox, {
    searchAsYouType: true,
    inputProps: {
      placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documents.search.placeholder', {
        defaultMessage: 'Filter documents...'
      }),
      'aria-label': _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documents.search.ariaLabel', {
        defaultMessage: 'Filter documents'
      }),
      'data-test-subj': 'DocumentsFilterInput'
    },
    view: _views.SearchBoxView
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "documentsSearchExperience__sidebar"
  }, /*#__PURE__*/_react.default.createElement(_reactSearchUi.Sorting, {
    className: "documentsSearchExperience__sorting",
    sortOptions: sortingOptions,
    view: _views.SortingView
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), fields.filterFields.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, fields.filterFields.map(fieldName => /*#__PURE__*/_react.default.createElement("section", {
    key: fieldName
  }, /*#__PURE__*/_react.default.createElement(_reactSearchUi.Facet, {
    field: fieldName,
    label: fieldName,
    view: _views.MultiCheckboxFacetsView,
    filterType: "any"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "customize",
    color: "primary",
    iconType: "gear",
    onClick: openCustomizationModal
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documents.search.customizationButton', {
    defaultMessage: 'Customize filters and sort'
  }))) : /*#__PURE__*/_react.default.createElement(_customization_callout.CustomizationCallout, {
    onClick: openCustomizationModal
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "documentsSearchExperience__content"
  }, /*#__PURE__*/_react.default.createElement(_search_experience_content.SearchExperienceContent, null)))), showCustomizationModal && /*#__PURE__*/_react.default.createElement(_customization_modal.CustomizationModal, {
    filterFields: fields.filterFields,
    sortFields: fields.sortFields,
    onClose: closeCustomizationModal,
    onSave: ({
      filterFields,
      sortFields
    }) => {
      setFields({
        filterFields,
        sortFields
      });
      closeCustomizationModal();
    }
  }));
};
exports.SearchExperience = SearchExperience;