"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentDetail = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../shared/constants");
var _encode_path_params = require("../../utils/encode_path_params");
var _engine = require("../engine");
var _layout = require("../layout");
var _result = require("../result");
var _constants2 = require("./constants");
var _document_detail_logic = require("./document_detail_logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DOCUMENT_DETAIL_TITLE = documentId => _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documentDetail.title', {
  defaultMessage: 'Document: {documentId}',
  values: {
    documentId
  }
});
const DocumentDetail = () => {
  const {
    dataLoading,
    fields
  } = (0, _kea.useValues)(_document_detail_logic.DocumentDetailLogic);
  const {
    deleteDocument,
    getDocumentDetails,
    setFields
  } = (0, _kea.useActions)(_document_detail_logic.DocumentDetailLogic);
  const {
    isMetaEngine,
    isElasticsearchEngine
  } = (0, _kea.useValues)(_engine.EngineLogic);
  const showDeleteButton = !isMetaEngine && !isElasticsearchEngine;
  const {
    documentId
  } = (0, _reactRouterDom.useParams)();
  const {
    documentId: documentTitle
  } = (0, _encode_path_params.useDecodedParams)();
  (0, _react.useEffect)(() => {
    getDocumentDetails(documentId);
    return () => {
      setFields([]);
    };
  }, []);
  const columns = [{
    name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documentDetail.fieldHeader', {
      defaultMessage: 'Field'
    }),
    width: '20%',
    render: field => field.name
  }, {
    name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documentDetail.valueHeader', {
      defaultMessage: 'Value'
    }),
    width: '80%',
    render: ({
      value,
      type
    }) => /*#__PURE__*/_react.default.createElement(_result.ResultFieldValue, {
      raw: value,
      type: type
    })
  }];
  const deleteButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "danger",
    iconType: "trash",
    onClick: () => deleteDocument(documentId),
    "data-test-subj": "DeleteDocumentButton"
  }, _constants.DELETE_BUTTON_LABEL);
  return /*#__PURE__*/_react.default.createElement(_layout.AppSearchPageTemplate, {
    pageChrome: (0, _engine.getEngineBreadcrumbs)([_constants2.DOCUMENTS_TITLE, documentTitle]),
    pageHeader: {
      pageTitle: DOCUMENT_DETAIL_TITLE(documentTitle),
      rightSideItems: showDeleteButton ? [deleteButton] : []
    },
    isLoading: dataLoading
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    items: fields
  })));
};
exports.DocumentDetail = DocumentDetail;