"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyState = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _routes = require("../../../routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmptyState = () => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  "data-test-subj": "EmptyDocumentPrompt",
  iconType: "documents",
  title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documents.empty.title', {
    defaultMessage: 'Add your first documents'
  })),
  body: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documents.empty.description', {
    defaultMessage: 'You can index documents using the App Search Web Crawler, by uploading JSON, or by using the API.'
  })),
  actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    target: "_blank",
    iconType: "popout",
    href: _routes.INDEXING_DOCS_URL
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.documents.empty.buttonLabel', {
    defaultMessage: 'Read the documents guide'
  }))
});
exports.EmptyState = EmptyState;