"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Curations = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _i18n = require("@kbn/i18n");
var _react_router_helpers = require("../../../../shared/react_router_helpers");
var _routes = require("../../../routes");
var _engine = require("../../engine");
var _layout = require("../../layout");
var _constants = require("../constants");
var _curations_logic = require("../curations_logic");
var _utils = require("../utils");
var _curations_history = require("./curations_history/curations_history");
var _curations_overview = require("./curations_overview");
var _curations_settings = require("./curations_settings");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Curations = () => {
  const {
    dataLoading,
    meta,
    selectedPageTab
  } = (0, _kea.useValues)(_curations_logic.CurationsLogic);
  const {
    loadCurations,
    onSelectPageTab
  } = (0, _kea.useActions)(_curations_logic.CurationsLogic);
  const {
    engine: {
      adaptive_relevance_suggestions_active: adaptiveRelevanceSuggestionsActive
    }
  } = (0, _kea.useValues)(_engine.EngineLogic);
  const OVERVIEW_TAB = {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.overviewPageTabLabel', {
      defaultMessage: 'Overview'
    }),
    isSelected: selectedPageTab === 'overview',
    onClick: () => onSelectPageTab('overview')
  };
  const HISTORY_TAB = {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.historyPageTabLabel', {
      defaultMessage: 'History'
    }),
    isSelected: selectedPageTab === 'history',
    onClick: () => onSelectPageTab('history')
  };
  const SETTINGS_TAB = {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.settingsPageTabLabel', {
      defaultMessage: 'Settings'
    }),
    isSelected: selectedPageTab === 'settings',
    onClick: () => onSelectPageTab('settings')
  };
  const pageTabs = adaptiveRelevanceSuggestionsActive ? [OVERVIEW_TAB, HISTORY_TAB, SETTINGS_TAB] : [OVERVIEW_TAB, SETTINGS_TAB];
  (0, _react.useEffect)(() => {
    loadCurations();
  }, [meta.page.current]);
  return /*#__PURE__*/_react.default.createElement(_layout.AppSearchPageTemplate, {
    pageChrome: (0, _utils.getCurationsBreadcrumbs)(),
    pageHeader: {
      pageTitle: _constants.CURATIONS_OVERVIEW_TITLE,
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
        to: (0, _engine.generateEnginePath)(_routes.ENGINE_CURATIONS_NEW_PATH),
        iconType: "plusInCircle",
        fill: true
      }, _constants.CREATE_NEW_CURATION_TITLE)],
      tabs: dataLoading ? undefined : pageTabs
    },
    isLoading: dataLoading
  }, selectedPageTab === 'overview' && /*#__PURE__*/_react.default.createElement(_curations_overview.CurationsOverview, null), selectedPageTab === 'history' && /*#__PURE__*/_react.default.createElement(_curations_history.CurationsHistory, null), selectedPageTab === 'settings' && /*#__PURE__*/_react.default.createElement(_curations_settings.CurationsSettings, null));
};
exports.Curations = Curations;