"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuggestedDocumentsCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _i18n = require("@kbn/i18n");
var _routes = require("../../../routes");
var _engine = require("../../engine");
var _suggestions_callout = require("../components/suggestions_callout");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SuggestedDocumentsCallout = () => {
  const {
    curation: {
      suggestion,
      queries
    }
  } = (0, _kea.useValues)(_.CurationLogic);
  const {
    engine: {
      adaptive_relevance_suggestions_active: adaptiveRelevanceSuggestionsActive
    }
  } = (0, _kea.useValues)(_engine.EngineLogic);
  if (typeof suggestion === 'undefined' || suggestion.status !== 'pending' || adaptiveRelevanceSuggestionsActive === false) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_suggestions_callout.SuggestionsCallout, {
    style: {
      marginTop: '24px'
    },
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curation.suggestedDocumentsCallout.title', {
      defaultMessage: 'New suggested documents for this query'
    }),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curation.suggestedDocumentsCallout.description', {
      defaultMessage: "Based on your engine's analytics, there are new suggested document promotions ready to review."
    }),
    buttonTo: (0, _engine.generateEnginePath)(_routes.ENGINE_CURATION_SUGGESTION_PATH, {
      query: queries[0]
    }),
    lastUpdatedTimestamp: suggestion.updated_at
  });
};
exports.SuggestedDocumentsCallout = SuggestedDocumentsCallout;