"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormKeyType = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _app_logic = require("../../../../app_logic");
var _constants = require("../../constants");
var _credentials_logic = require("../../credentials_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FormKeyType = () => {
  const {
    myRole
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const {
    setTokenType
  } = (0, _kea.useActions)(_credentials_logic.CredentialsLogic);
  const {
    activeApiToken,
    activeApiTokenExists
  } = (0, _kea.useValues)(_credentials_logic.CredentialsLogic);
  const tokenDescription = _constants.TOKEN_TYPE_DESCRIPTION[activeApiToken.type];
  const tokenOptions = _constants.TOKEN_TYPE_INFO.filter(typeInfo => {
    var _myRole$credentialTyp;
    return myRole === null || myRole === void 0 ? void 0 : (_myRole$credentialTyp = myRole.credentialTypes) === null || _myRole$credentialTyp === void 0 ? void 0 : _myRole$credentialTyp.includes(typeInfo.value);
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.formType.label', {
      defaultMessage: 'Key type'
    }),
    fullWidth: true,
    helpText: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("strong", null, tokenDescription), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: _constants.DOCS_HREF
    }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.documentationLink1', {
      defaultMessage: 'Visit the documentation'
    })), ' ', _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.documentationLink2', {
      defaultMessage: 'to learn more about keys.'
    })))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    name: "token_type",
    options: tokenOptions,
    value: activeApiToken.type,
    onChange: e => setTokenType(e.target.value),
    placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.formType.placeholder', {
      defaultMessage: 'Select a key type'
    }),
    disabled: activeApiTokenExists,
    required: true,
    fullWidth: true
  }));
};
exports.FormKeyType = FormKeyType;