"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrawlCustomSettingsFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../shared/constants");
var _loading = require("../../../../../shared/loading");
var _crawl_custom_settings_flyout_crawl_depth_panel = require("./crawl_custom_settings_flyout_crawl_depth_panel");
var _crawl_custom_settings_flyout_domains_panel = require("./crawl_custom_settings_flyout_domains_panel");
var _crawl_custom_settings_flyout_logic = require("./crawl_custom_settings_flyout_logic");
var _crawl_custom_settings_flyout_seed_urls_panel = require("./crawl_custom_settings_flyout_seed_urls_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CrawlCustomSettingsFlyout = () => {
  const {
    isDataLoading,
    isFormSubmitting,
    isFlyoutVisible,
    selectedDomainUrls
  } = (0, _kea.useValues)(_crawl_custom_settings_flyout_logic.CrawlCustomSettingsFlyoutLogic);
  const {
    hideFlyout,
    startCustomCrawl
  } = (0, _kea.useActions)(_crawl_custom_settings_flyout_logic.CrawlCustomSettingsFlyoutLogic);
  if (!isFlyoutVisible) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: hideFlyout,
    size: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlCustomSettingsFlyout.flyoutHeadTitle', {
    defaultMessage: 'Custom crawl configuration'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlCustomSettingsFlyout.flyoutHeaderDescription', {
    defaultMessage: 'Set up a one-time crawl with custom settings.'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, isDataLoading ? /*#__PURE__*/_react.default.createElement(_loading.Loading, null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_crawl_custom_settings_flyout_crawl_depth_panel.CrawlCustomSettingsFlyoutCrawlDepthPanel, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_crawl_custom_settings_flyout_domains_panel.CrawlCustomSettingsFlyoutDomainsPanel, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_crawl_custom_settings_flyout_seed_urls_panel.CrawlCustomSettingsFlyoutSeedUrlsPanel, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: hideFlyout
  }, _constants.CANCEL_BUTTON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: startCustomCrawl,
    disabled: isDataLoading || selectedDomainUrls.length === 0,
    isLoading: isFormSubmitting
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlCustomSettingsFlyout.startCrawlButtonLabel', {
    defaultMessage: 'Apply and crawl now'
  }))))));
};
exports.CrawlCustomSettingsFlyout = CrawlCustomSettingsFlyout;