"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApiLogLogic = void 0;
var _kea = require("kea");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ApiLogLogic = (0, _kea.kea)({
  path: ['enterprise_search', 'app_search', 'api_log_logic'],
  actions: () => ({
    openFlyout: apiLog => ({
      apiLog
    }),
    closeFlyout: true
  }),
  reducers: () => ({
    isFlyoutOpen: [false, {
      openFlyout: () => true,
      closeFlyout: () => false
    }],
    apiLog: [null, {
      openFlyout: (_, {
        apiLog
      }) => apiLog,
      closeFlyout: () => null
    }]
  })
});
exports.ApiLogLogic = ApiLogLogic;