"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TERM_COLUMN_PROPS = exports.TAGS_LIST_COLUMN = exports.TAGS_COUNT_COLUMN = exports.TAGS_COLUMN_PROPS = exports.FIRST_COLUMN_PROPS = exports.COUNT_COLUMN_PROPS = exports.ACTIONS_COLUMN = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../shared/constants");
var _flash_messages = require("../../../../../shared/flash_messages");
var _http = require("../../../../../shared/http");
var _kibana = require("../../../../../shared/kibana");
var _react_router_helpers = require("../../../../../shared/react_router_helpers");
var _routes = require("../../../../routes");
var _engine = require("../../../engine");
var _tags = require("./tags");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Shared columns / column properties between separate analytics tables
 */

const FIRST_COLUMN_PROPS = {
  truncateText: true,
  width: '25%',
  mobileOptions: {
    enlarge: true,
    width: '100%'
  }
};
exports.FIRST_COLUMN_PROPS = FIRST_COLUMN_PROPS;
const TERM_COLUMN_PROPS = {
  // Field key changes per-table
  name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.table.termColumn', {
    defaultMessage: 'Search term'
  }),
  render: query => {
    if (!query) query = '""';
    return /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
      to: (0, _engine.generateEnginePath)(_routes.ENGINE_ANALYTICS_QUERY_DETAIL_PATH, {
        query
      })
    }, query);
  },
  ...FIRST_COLUMN_PROPS
};
exports.TERM_COLUMN_PROPS = TERM_COLUMN_PROPS;
const ACTIONS_COLUMN = {
  width: '90px',
  actions: [{
    name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.table.viewAction', {
      defaultMessage: 'View'
    }),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.table.viewTooltip', {
      defaultMessage: 'View query analytics'
    }),
    type: 'icon',
    icon: 'eye',
    color: 'primary',
    onClick: item => {
      const {
        navigateToUrl
      } = _kibana.KibanaLogic.values;
      const query = item.key || item.query_string || '""';
      navigateToUrl((0, _engine.generateEnginePath)(_routes.ENGINE_ANALYTICS_QUERY_DETAIL_PATH, {
        query
      }));
    },
    'data-test-subj': 'AnalyticsTableViewQueryButton'
  }, {
    name: _constants.EDIT_BUTTON_LABEL,
    description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.table.editTooltip', {
      defaultMessage: 'Manage curation'
    }),
    type: 'icon',
    icon: 'package',
    onClick: async item => {
      const {
        http
      } = _http.HttpLogic.values;
      const {
        navigateToUrl
      } = _kibana.KibanaLogic.values;
      const {
        engineName
      } = _engine.EngineLogic.values;
      try {
        const query = item.key || item.query_string || '""';
        const response = await http.post(`/internal/app_search/engines/${engineName}/curations/find_or_create`, {
          body: JSON.stringify({
            query
          })
        });
        navigateToUrl((0, _engine.generateEnginePath)(_routes.ENGINE_CURATION_PATH, {
          curationId: response.id
        }));
      } catch (e) {
        (0, _flash_messages.flashAPIErrors)(e);
      }
    },
    'data-test-subj': 'AnalyticsTableEditQueryButton'
  }]
};
exports.ACTIONS_COLUMN = ACTIONS_COLUMN;
const TAGS_COLUMN_PROPS = {
  field: 'tags',
  name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.table.tagsColumn', {
    defaultMessage: 'Analytics tags'
  }),
  truncateText: true
};
exports.TAGS_COLUMN_PROPS = TAGS_COLUMN_PROPS;
const TAGS_LIST_COLUMN = {
  ...TAGS_COLUMN_PROPS,
  render: tags => /*#__PURE__*/_react.default.createElement(_tags.TagsList, {
    tags: tags
  })
};
exports.TAGS_LIST_COLUMN = TAGS_LIST_COLUMN;
const TAGS_COUNT_COLUMN = {
  ...TAGS_COLUMN_PROPS,
  render: tags => /*#__PURE__*/_react.default.createElement(_tags.TagsCount, {
    tags: tags
  })
};
exports.TAGS_COUNT_COLUMN = TAGS_COUNT_COLUMN;
const COUNT_COLUMN_PROPS = {
  dataType: 'number',
  width: '100px'
};
exports.COUNT_COLUMN_PROPS = COUNT_COLUMN_PROPS;