"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsLogic = void 0;
var _kea = require("kea");
var _queryString = _interopRequireDefault(require("query-string"));
var _flash_messages = require("../../../shared/flash_messages");
var _http = require("../../../shared/http");
var _kibana = require("../../../shared/kibana");
var _engine = require("../engine");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnalyticsLogic = (0, _kea.kea)({
  path: ['enterprise_search', 'app_search', 'analytics_logic'],
  actions: () => ({
    onAnalyticsDataLoad: data => data,
    onQueryDataLoad: data => data,
    loadAnalyticsData: true,
    loadQueryData: query => query
  }),
  reducers: () => ({
    dataLoading: [true, {
      loadAnalyticsData: () => true,
      loadQueryData: () => true,
      onAnalyticsDataLoad: () => false,
      onQueryDataLoad: () => false
    }],
    allTags: [[], {
      onAnalyticsDataLoad: (_, {
        allTags
      }) => allTags,
      onQueryDataLoad: (_, {
        allTags
      }) => allTags
    }],
    recentQueries: [[], {
      onAnalyticsDataLoad: (_, {
        recentQueries
      }) => recentQueries
    }],
    topQueries: [[], {
      onAnalyticsDataLoad: (_, {
        topQueries
      }) => topQueries
    }],
    topQueriesNoResults: [[], {
      onAnalyticsDataLoad: (_, {
        topQueriesNoResults
      }) => topQueriesNoResults
    }],
    topQueriesNoClicks: [[], {
      onAnalyticsDataLoad: (_, {
        topQueriesNoClicks
      }) => topQueriesNoClicks
    }],
    topQueriesWithClicks: [[], {
      onAnalyticsDataLoad: (_, {
        topQueriesWithClicks
      }) => topQueriesWithClicks
    }],
    totalQueries: [0, {
      onAnalyticsDataLoad: (_, {
        totalQueries
      }) => totalQueries
    }],
    totalQueriesNoResults: [0, {
      onAnalyticsDataLoad: (_, {
        totalQueriesNoResults
      }) => totalQueriesNoResults
    }],
    totalClicks: [0, {
      onAnalyticsDataLoad: (_, {
        totalClicks
      }) => totalClicks
    }],
    queriesPerDay: [[], {
      onAnalyticsDataLoad: (_, {
        queriesPerDay
      }) => queriesPerDay
    }],
    queriesNoResultsPerDay: [[], {
      onAnalyticsDataLoad: (_, {
        queriesNoResultsPerDay
      }) => queriesNoResultsPerDay
    }],
    clicksPerDay: [[], {
      onAnalyticsDataLoad: (_, {
        clicksPerDay
      }) => clicksPerDay
    }],
    totalQueriesForQuery: [0, {
      onQueryDataLoad: (_, {
        totalQueriesForQuery
      }) => totalQueriesForQuery
    }],
    queriesPerDayForQuery: [[], {
      onQueryDataLoad: (_, {
        queriesPerDayForQuery
      }) => queriesPerDayForQuery
    }],
    topClicksForQuery: [[], {
      onQueryDataLoad: (_, {
        topClicksForQuery
      }) => topClicksForQuery
    }],
    startDate: ['', {
      onAnalyticsDataLoad: (_, {
        startDate
      }) => startDate,
      onQueryDataLoad: (_, {
        startDate
      }) => startDate
    }]
  }),
  listeners: ({
    actions
  }) => ({
    loadAnalyticsData: async () => {
      const {
        history
      } = _kibana.KibanaLogic.values;
      const {
        http
      } = _http.HttpLogic.values;
      const {
        engineName
      } = _engine.EngineLogic.values;
      try {
        const {
          start,
          end,
          tag
        } = _queryString.default.parse(history.location.search);
        const query = {
          start: start || _constants.DEFAULT_START_DATE,
          end: end || _constants.DEFAULT_END_DATE,
          tag,
          size: 20
        };
        const url = `/internal/app_search/engines/${engineName}/analytics/queries`;
        const response = await http.get(url, {
          query
        });
        actions.onAnalyticsDataLoad(response);
      } catch (e) {
        (0, _flash_messages.flashAPIErrors)(e);
      }
    },
    loadQueryData: async query => {
      const {
        history
      } = _kibana.KibanaLogic.values;
      const {
        http
      } = _http.HttpLogic.values;
      const {
        engineName
      } = _engine.EngineLogic.values;
      try {
        const {
          start,
          end,
          tag
        } = _queryString.default.parse(history.location.search);
        const queryParams = {
          start: start || _constants.DEFAULT_START_DATE,
          end: end || _constants.DEFAULT_END_DATE,
          tag
        };
        const url = `/internal/app_search/engines/${engineName}/analytics/queries/${query}`;
        const response = await http.get(url, {
          query: queryParams
        });
        actions.onQueryDataLoad(response);
      } catch (e) {
        (0, _flash_messages.flashAPIErrors)(e);
      }
    }
  })
});
exports.AnalyticsLogic = AnalyticsLogic;