"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteAnalyticsCollectionLogic = void 0;
var _kea = require("kea");
var _api = require("../../../../../common/types/api");
var _kibana = require("../../../shared/kibana");
var _delete_analytics_collection_api_logic = require("../../api/delete_analytics_collection/delete_analytics_collection_api_logic");
var _routes = require("../../routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeleteAnalyticsCollectionLogic = (0, _kea.kea)({
  actions: {
    deleteAnalyticsCollection: name => ({
      name
    })
  },
  connect: {
    actions: [_delete_analytics_collection_api_logic.DeleteAnalyticsCollectionAPILogic, ['makeRequest', 'apiSuccess']],
    values: [_delete_analytics_collection_api_logic.DeleteAnalyticsCollectionAPILogic, ['status']]
  },
  listeners: ({
    actions
  }) => ({
    apiSuccess: async (_, breakpoint) => {
      // Wait for propagation of the collection deletion
      await breakpoint(1000);
      _kibana.KibanaLogic.values.navigateToUrl(_routes.ROOT_PATH);
    },
    deleteAnalyticsCollection: ({
      name
    }) => {
      actions.makeRequest({
        name
      });
    }
  }),
  path: ['enterprise_search', 'analytics', 'collection', 'delete'],
  selectors: ({
    selectors
  }) => ({
    isLoading: [() => [selectors.status], status => [_api.Status.LOADING, _api.Status.IDLE].includes(status)]
  })
});
exports.DeleteAnalyticsCollectionLogic = DeleteAnalyticsCollectionLogic;