"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsCollectionOverviewTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _encode_path_params = require("../../../../shared/encode_path_params");
var _kibana = require("../../../../shared/kibana");
var _routes = require("../../../routes");
var _get_flag = require("../../../utils/get_flag");
var _get_formula_by_filter = require("../../../utils/get_formula_by_filter");
var _analytics_collection_explore_table_logic = require("../analytics_collection_explore_table_logic");
var _analytics_collection_explore_table_types = require("../analytics_collection_explore_table_types");
var _fetch_analytics_collection_logic = require("../fetch_analytics_collection_logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const tabsByFilter = {
  [_get_formula_by_filter.FilterBy.Searches]: [{
    id: _analytics_collection_explore_table_types.ExploreTables.SearchTerms,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.exploreTab.searchTerms', {
      defaultMessage: 'Popular search terms'
    })
  }],
  [_get_formula_by_filter.FilterBy.NoResults]: [{
    id: _analytics_collection_explore_table_types.ExploreTables.WorsePerformers,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.exploreTab.worsePerformers', {
      defaultMessage: 'Worse performers'
    })
  }],
  [_get_formula_by_filter.FilterBy.Clicks]: [{
    id: _analytics_collection_explore_table_types.ExploreTables.Clicked,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.exploreTab.topClicked', {
      defaultMessage: 'Top clicked results'
    })
  }],
  [_get_formula_by_filter.FilterBy.Sessions]: [{
    id: _analytics_collection_explore_table_types.ExploreTables.Locations,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.exploreTab.topLocations', {
      defaultMessage: 'Top locations'
    })
  }, {
    id: _analytics_collection_explore_table_types.ExploreTables.Referrers,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.exploreTab.topReferrers', {
      defaultMessage: 'Top referrers'
    })
  }]
};
const tableSettings = {
  [_analytics_collection_explore_table_types.ExploreTables.SearchTerms]: {
    columns: [{
      field: _analytics_collection_explore_table_types.ExploreTableColumns.searchTerms,
      name: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.exploreTable.searchTerms', {
        defaultMessage: 'Search Terms'
      }),
      truncateText: true
    }, {
      align: 'right',
      field: _analytics_collection_explore_table_types.ExploreTableColumns.count,
      name: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.exploreTable.count', {
        defaultMessage: 'Count'
      }),
      sortable: true,
      truncateText: true
    }],
    sorting: {
      readOnly: true,
      sort: {
        direction: 'desc',
        field: _analytics_collection_explore_table_types.ExploreTableColumns.count
      }
    }
  },
  [_analytics_collection_explore_table_types.ExploreTables.WorsePerformers]: {
    columns: [{
      field: _analytics_collection_explore_table_types.ExploreTableColumns.query,
      name: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.exploreTable.query', {
        defaultMessage: 'Query'
      }),
      truncateText: true
    }, {
      align: 'right',
      field: _analytics_collection_explore_table_types.ExploreTableColumns.count,
      name: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.exploreTable.count', {
        defaultMessage: 'Count'
      }),
      sortable: true,
      truncateText: true
    }],
    sorting: {
      readOnly: true,
      sort: {
        direction: 'desc',
        field: _analytics_collection_explore_table_types.ExploreTableColumns.count
      }
    }
  },
  [_analytics_collection_explore_table_types.ExploreTables.Clicked]: {
    columns: [{
      field: _analytics_collection_explore_table_types.ExploreTableColumns.page,
      name: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.exploreTable.page', {
        defaultMessage: 'Page'
      }),
      render: euiTheme => value => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: euiTheme.colors.primaryText
      }, /*#__PURE__*/_react.default.createElement("p", null, value)),
      truncateText: true
    }, {
      align: 'right',
      field: _analytics_collection_explore_table_types.ExploreTableColumns.count,
      name: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.exploreTable.count', {
        defaultMessage: 'Count'
      }),
      sortable: true,
      truncateText: true
    }],
    sorting: {
      readOnly: true,
      sort: {
        direction: 'desc',
        field: _analytics_collection_explore_table_types.ExploreTableColumns.count
      }
    }
  },
  [_analytics_collection_explore_table_types.ExploreTables.Referrers]: {
    columns: [{
      field: _analytics_collection_explore_table_types.ExploreTableColumns.page,
      name: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.exploreTable.page', {
        defaultMessage: 'Page'
      }),
      render: euiTheme => value => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: euiTheme.colors.primaryText
      }, /*#__PURE__*/_react.default.createElement("p", null, value)),
      truncateText: true
    }, {
      align: 'right',
      field: _analytics_collection_explore_table_types.ExploreTableColumns.sessions,
      name: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.exploreTable.session', {
        defaultMessage: 'Session'
      }),
      sortable: true,
      truncateText: true
    }],
    sorting: {
      readOnly: true,
      sort: {
        direction: 'desc',
        field: _analytics_collection_explore_table_types.ExploreTableColumns.sessions
      }
    }
  },
  [_analytics_collection_explore_table_types.ExploreTables.Locations]: {
    columns: [{
      field: _analytics_collection_explore_table_types.ExploreTableColumns.location,
      name: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.exploreTable.location', {
        defaultMessage: 'Location'
      }),
      render: euiTheme => (value, data) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "m",
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h3", null, (0, _get_flag.getFlag)(data.countryISOCode))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: euiTheme.colors.primaryText
      }, /*#__PURE__*/_react.default.createElement("p", null, value))),
      truncateText: true
    }, {
      align: 'right',
      field: _analytics_collection_explore_table_types.ExploreTableColumns.sessions,
      name: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.exploreTable.session', {
        defaultMessage: 'Session'
      }),
      sortable: true,
      truncateText: true
    }],
    sorting: {
      readOnly: true,
      sort: {
        direction: 'desc',
        field: _analytics_collection_explore_table_types.ExploreTableColumns.sessions
      }
    }
  }
};
const AnalyticsCollectionOverviewTable = ({
  filterBy
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    navigateToUrl
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    analyticsCollection
  } = (0, _kea.useValues)(_fetch_analytics_collection_logic.FetchAnalyticsCollectionLogic);
  const {
    onTableChange,
    setSelectedTable
  } = (0, _kea.useActions)(_analytics_collection_explore_table_logic.AnalyticsCollectionExploreTableLogic);
  const {
    items,
    isLoading,
    selectedTable,
    sorting
  } = (0, _kea.useValues)(_analytics_collection_explore_table_logic.AnalyticsCollectionExploreTableLogic);
  const tabs = tabsByFilter[filterBy];
  (0, _react.useEffect)(() => {
    var _tableSettings$firstT, _tableSettings$firstT2;
    const firstTableInTabsId = tabs[0].id;
    setSelectedTable(firstTableInTabsId, (_tableSettings$firstT = tableSettings[firstTableInTabsId]) === null || _tableSettings$firstT === void 0 ? void 0 : (_tableSettings$firstT2 = _tableSettings$firstT.sorting) === null || _tableSettings$firstT2 === void 0 ? void 0 : _tableSettings$firstT2.sort);
  }, [tabs]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, null, tabs === null || tabs === void 0 ? void 0 : tabs.map(({
    id,
    name
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: id,
    onClick: () => {
      var _tableSettings$id, _tableSettings$id$sor;
      return setSelectedTable(id, (_tableSettings$id = tableSettings[id]) === null || _tableSettings$id === void 0 ? void 0 : (_tableSettings$id$sor = _tableSettings$id.sorting) === null || _tableSettings$id$sor === void 0 ? void 0 : _tableSettings$id$sor.sort);
    },
    isSelected: id === selectedTable
  }, name))), (0, _react.useMemo)(() => {
    const table = selectedTable !== null && tableSettings[selectedTable];
    return table && /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
      columns: table.columns.map(column => {
        var _column$render;
        return {
          ...column,
          render: (_column$render = column.render) === null || _column$render === void 0 ? void 0 : _column$render.call(column, euiTheme)
        };
      }),
      itemId: selectedTable,
      items: items,
      loading: isLoading,
      sorting: table.sorting,
      onChange: ({
        sort
      }) => {
        onTableChange({
          sort
        });
      }
    });
  }, [selectedTable, sorting, items, isLoading]), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: () => navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.COLLECTION_EXPLORER_PATH, {
      name: analyticsCollection.name
    }))
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.analytics.collections.collectionsView.list.exploreButton",
    defaultMessage: "Explore all"
  }))));
};
exports.AnalyticsCollectionOverviewTable = AnalyticsCollectionOverviewTable;