"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsCollectionNoEventsCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _encode_path_params = require("../../../../shared/encode_path_params");
var _kibana = require("../../../../shared/kibana");
var _routes = require("../../../routes");
var _analytics_collection_no_events_callout_logic = require("./analytics_collection_no_events_callout_logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnalyticsCollectionNoEventsCallout = ({
  analyticsCollection
}) => {
  const {
    navigateToUrl
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    analyticsEventsExist
  } = (0, _kea.useActions)(_analytics_collection_no_events_callout_logic.AnalyticsCollectionNoEventsCalloutLogic);
  const {
    hasEvents,
    isLoading
  } = (0, _kea.useValues)(_analytics_collection_no_events_callout_logic.AnalyticsCollectionNoEventsCalloutLogic);
  (0, _react.useEffect)(() => {
    analyticsEventsExist(analyticsCollection.events_datastream);
  }, []);
  return hasEvents || isLoading ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "primary",
    iconType: "download",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collectionsView.noEventsCallout.title', {
      defaultMessage: 'Install our tracker'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collectionsView.noEventsCallout.description', {
    defaultMessage: 'Start receiving metric data in this Collection by installing our tracker in your search application.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    type: "submit",
    onClick: () => navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.COLLECTION_INTEGRATE_PATH, {
      name: analyticsCollection.name
    }))
  }, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collectionsView.noEventsCallout.button', {
    defaultMessage: 'Learn how'
  })));
};
exports.AnalyticsCollectionNoEventsCallout = AnalyticsCollectionNoEventsCallout;