"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsCollectionExplorerTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _get_flag = require("../../../utils/get_flag");
var _analytics_collection_explore_table_logic = require("../analytics_collection_explore_table_logic");
var _analytics_collection_explore_table_types = require("../analytics_collection_explore_table_types");
var _analytics_collection_explorer_callout = require("./analytics_collection_explorer_callout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const tabs = [{
  id: _analytics_collection_explore_table_types.ExploreTables.SearchTerms,
  name: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.explorer.searchTermsTab', {
    defaultMessage: 'Search terms'
  })
}, {
  id: _analytics_collection_explore_table_types.ExploreTables.Clicked,
  name: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.explorer.topClickedTab', {
    defaultMessage: 'Top clicked results'
  })
}, {
  id: _analytics_collection_explore_table_types.ExploreTables.WorsePerformers,
  name: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.explorer.noResultsTab', {
    defaultMessage: 'No results'
  })
}, {
  id: _analytics_collection_explore_table_types.ExploreTables.Locations,
  name: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.explorer.locationsTab', {
    defaultMessage: 'Locations'
  })
}, {
  id: _analytics_collection_explore_table_types.ExploreTables.Referrers,
  name: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.explorer.referrersTab', {
    defaultMessage: 'Referrers'
  })
}];
const tableSettings = {
  [_analytics_collection_explore_table_types.ExploreTables.SearchTerms]: {
    columns: [{
      field: _analytics_collection_explore_table_types.ExploreTableColumns.searchTerms,
      name: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.exploreTable.searchTerms', {
        defaultMessage: 'Search Terms'
      }),
      sortable: true,
      truncateText: true
    }, {
      align: 'right',
      field: _analytics_collection_explore_table_types.ExploreTableColumns.count,
      name: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.exploreTable.count', {
        defaultMessage: 'Count'
      }),
      sortable: true,
      truncateText: true
    }],
    sorting: {
      sort: {
        direction: 'desc',
        field: _analytics_collection_explore_table_types.ExploreTableColumns.count
      }
    }
  },
  [_analytics_collection_explore_table_types.ExploreTables.WorsePerformers]: {
    columns: [{
      field: _analytics_collection_explore_table_types.ExploreTableColumns.query,
      name: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.exploreTable.query', {
        defaultMessage: 'Query'
      }),
      sortable: true,
      truncateText: true
    }, {
      align: 'right',
      field: _analytics_collection_explore_table_types.ExploreTableColumns.count,
      name: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.exploreTable.count', {
        defaultMessage: 'Count'
      }),
      sortable: true,
      truncateText: true
    }],
    sorting: {
      sort: {
        direction: 'desc',
        field: _analytics_collection_explore_table_types.ExploreTableColumns.count
      }
    }
  },
  [_analytics_collection_explore_table_types.ExploreTables.Clicked]: {
    columns: [{
      field: _analytics_collection_explore_table_types.ExploreTableColumns.page,
      name: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.exploreTable.page', {
        defaultMessage: 'Page'
      }),
      render: euiTheme => value => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: euiTheme.colors.primaryText
      }, /*#__PURE__*/_react.default.createElement("p", null, value)),
      sortable: true,
      truncateText: true
    }, {
      align: 'right',
      field: _analytics_collection_explore_table_types.ExploreTableColumns.count,
      name: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.exploreTable.count', {
        defaultMessage: 'Count'
      }),
      sortable: true,
      truncateText: true
    }],
    sorting: {
      sort: {
        direction: 'desc',
        field: _analytics_collection_explore_table_types.ExploreTableColumns.count
      }
    }
  },
  [_analytics_collection_explore_table_types.ExploreTables.Referrers]: {
    columns: [{
      field: _analytics_collection_explore_table_types.ExploreTableColumns.page,
      name: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.exploreTable.page', {
        defaultMessage: 'Page'
      }),
      render: euiTheme => value => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: euiTheme.colors.primaryText
      }, /*#__PURE__*/_react.default.createElement("p", null, value)),
      sortable: true,
      truncateText: true
    }, {
      align: 'right',
      field: _analytics_collection_explore_table_types.ExploreTableColumns.sessions,
      name: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.exploreTable.session', {
        defaultMessage: 'Session'
      }),
      sortable: true,
      truncateText: true
    }],
    sorting: {
      sort: {
        direction: 'desc',
        field: _analytics_collection_explore_table_types.ExploreTableColumns.sessions
      }
    }
  },
  [_analytics_collection_explore_table_types.ExploreTables.Locations]: {
    columns: [{
      field: _analytics_collection_explore_table_types.ExploreTableColumns.location,
      name: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.exploreTable.location', {
        defaultMessage: 'Location'
      }),
      render: euiTheme => (value, data) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "m",
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h3", null, (0, _get_flag.getFlag)(data.countryISOCode))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: euiTheme.colors.primaryText
      }, /*#__PURE__*/_react.default.createElement("p", null, value))),
      sortable: true,
      truncateText: true
    }, {
      align: 'right',
      field: _analytics_collection_explore_table_types.ExploreTableColumns.sessions,
      name: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.exploreTable.session', {
        defaultMessage: 'Session'
      }),
      sortable: true,
      truncateText: true
    }],
    sorting: {
      sort: {
        direction: 'desc',
        field: _analytics_collection_explore_table_types.ExploreTableColumns.sessions
      }
    }
  }
};
const MAX_ITEMS = 10000;
const AnalyticsCollectionExplorerTable = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    onTableChange,
    setSelectedTable,
    setSearch
  } = (0, _kea.useActions)(_analytics_collection_explore_table_logic.AnalyticsCollectionExploreTableLogic);
  const {
    items,
    isLoading,
    pageIndex,
    pageSize,
    search,
    selectedTable,
    sorting,
    totalItemsCount
  } = (0, _kea.useValues)(_analytics_collection_explore_table_logic.AnalyticsCollectionExploreTableLogic);
  let table = selectedTable !== null && tableSettings[selectedTable];
  if (table) {
    table = {
      ...table,
      columns: table.columns.map(column => {
        var _column$render;
        return {
          ...column,
          render: (_column$render = column.render) === null || _column$render === void 0 ? void 0 : _column$render.call(column, euiTheme)
        };
      }),
      sorting: {
        ...table.sorting,
        sort: sorting || undefined
      }
    };
  }
  const handleTableChange = ({
    sort,
    page
  }) => {
    onTableChange({
      page,
      sort
    });
  };
  const startNumberItemsOnPage = pageSize * pageIndex + (items.length ? 1 : 0);
  const endNumberItemsOnPage = pageSize * pageIndex + items.length;
  (0, _react.useEffect)(() => {
    if (!selectedTable) {
      var _tableSettings$firstT, _tableSettings$firstT2;
      const firstTabId = tabs[0].id;
      setSelectedTable(firstTabId, (_tableSettings$firstT = tableSettings[firstTabId]) === null || _tableSettings$firstT === void 0 ? void 0 : (_tableSettings$firstT2 = _tableSettings$firstT.sorting) === null || _tableSettings$firstT2 === void 0 ? void 0 : _tableSettings$firstT2.sort);
    }
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, null, tabs === null || tabs === void 0 ? void 0 : tabs.map(({
    id,
    name
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: id,
    onClick: () => {
      var _tableSettings$id, _tableSettings$id$sor;
      return setSelectedTable(id, (_tableSettings$id = tableSettings[id]) === null || _tableSettings$id === void 0 ? void 0 : (_tableSettings$id$sor = _tableSettings$id.sorting) === null || _tableSettings$id$sor === void 0 ? void 0 : _tableSettings$id$sor.sort);
    },
    isSelected: id === selectedTable
  }, name))), table && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collectionsView.explorer.searchPlaceholder', {
      defaultMessage: 'Search'
    }),
    value: search,
    onChange: event => setSearch(event.target.value),
    isClearable: true,
    isLoading: isLoading,
    incremental: true,
    fullWidth: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, totalItemsCount > MAX_ITEMS ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.analytics.collectionsView.explorer.tableSummaryIndeterminate",
    defaultMessage: "Showing {items} of first {maxItemsCount} results",
    values: {
      items: /*#__PURE__*/_react.default.createElement("strong", null, startNumberItemsOnPage, "-", endNumberItemsOnPage),
      maxItemsCount: /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
        value: MAX_ITEMS
      })
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.analytics.collectionsView.explorer.tableSummary",
    defaultMessage: "Showing {items} of {totalItemsCount}",
    values: {
      items: /*#__PURE__*/_react.default.createElement("strong", null, startNumberItemsOnPage, "-", endNumberItemsOnPage),
      totalItemsCount
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: table.columns,
    itemId: selectedTable || undefined,
    items: items,
    loading: isLoading,
    sorting: table.sorting,
    pagination: {
      pageIndex,
      pageSize,
      pageSizeOptions: [10, 20, 50],
      showPerPageOptions: true,
      totalItemCount: Math.min(totalItemsCount, MAX_ITEMS)
    },
    onChange: handleTableChange
  })), /*#__PURE__*/_react.default.createElement(_analytics_collection_explorer_callout.AnalyticsCollectionExplorerCallout, null));
};
exports.AnalyticsCollectionExplorerTable = AnalyticsCollectionExplorerTable;