"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkAnalyticsEventsExist = exports.AnalyticsEventsExistAPILogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const checkAnalyticsEventsExist = async ({
  indexName
}) => {
  const {
    http
  } = _http.HttpLogic.values;
  const route = `/internal/enterprise_search/analytics/collection/${indexName}/events/exist`;
  const response = await http.get(route);
  return response;
};
exports.checkAnalyticsEventsExist = checkAnalyticsEventsExist;
const AnalyticsEventsExistAPILogic = (0, _create_api_logic.createApiLogic)(['analytics', 'analytics_events_exist_api_logic'], checkAnalyticsEventsExist);
exports.AnalyticsEventsExistAPILogic = AnalyticsEventsExistAPILogic;