"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddablePublicPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/saved-objects-finder-plugin/public");
var _common = require("@kbn/kibana-utils-plugin/common");
var _bootstrap = require("./bootstrap");
var _lib = require("./lib");
var _state_transfer = require("./lib/state_transfer");
var _attribute_service = require("./lib/attribute_service");
var _lib2 = require("../common/lib");
var _get_all_migrations = require("../common/lib/get_all_migrations");
var _services = require("./services");
var _custom_time_range_badge = require("./lib/panel/panel_header/panel_actions/customize_panel/custom_time_range_badge");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class EmbeddablePublicPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "embeddableFactoryDefinitions", new Map());
    (0, _defineProperty2.default)(this, "embeddableFactories", new Map());
    (0, _defineProperty2.default)(this, "enhancements", new Map());
    (0, _defineProperty2.default)(this, "customEmbeddableFactoryProvider", void 0);
    (0, _defineProperty2.default)(this, "stateTransferService", {});
    (0, _defineProperty2.default)(this, "isRegistryReady", false);
    (0, _defineProperty2.default)(this, "appList", void 0);
    (0, _defineProperty2.default)(this, "appListSubscription", void 0);
    (0, _defineProperty2.default)(this, "registerEnhancement", enhancement => {
      if (this.enhancements.has(enhancement.id)) {
        throw new Error(`enhancement with id ${enhancement.id} already exists in the registry`);
      }
      this.enhancements.set(enhancement.id, {
        id: enhancement.id,
        telemetry: enhancement.telemetry || ((state, stats) => stats),
        inject: enhancement.inject || _lodash.identity,
        extract: enhancement.extract || (state => {
          return {
            state,
            references: []
          };
        }),
        migrations: enhancement.migrations || {}
      });
    });
    (0, _defineProperty2.default)(this, "getEnhancement", id => {
      return this.enhancements.get(id) || {
        id: 'unknown',
        telemetry: (state, stats) => stats,
        inject: _lodash.identity,
        extract: state => {
          return {
            state,
            references: []
          };
        },
        migrations: {}
      };
    });
    (0, _defineProperty2.default)(this, "getEmbeddableFactories", () => {
      this.ensureFactoriesExist();
      return this.embeddableFactories.values();
    });
    (0, _defineProperty2.default)(this, "registerEmbeddableFactory", (embeddableFactoryId, factory) => {
      if (this.embeddableFactoryDefinitions.has(embeddableFactoryId)) {
        throw new Error(`Embeddable factory [embeddableFactoryId = ${embeddableFactoryId}] already registered in Embeddables API.`);
      }
      this.embeddableFactoryDefinitions.set(embeddableFactoryId, factory);
      return () => {
        return this.getEmbeddableFactory(embeddableFactoryId);
      };
    });
    (0, _defineProperty2.default)(this, "getEmbeddableFactory", embeddableFactoryId => {
      if (!this.isRegistryReady) {
        throw new Error('Embeddable factories can only be retrieved after setup lifecycle.');
      }
      this.ensureFactoryExists(embeddableFactoryId);
      const factory = this.embeddableFactories.get(embeddableFactoryId);
      return factory;
    });
    // These two functions are only to support legacy plugins registering factories after the start lifecycle.
    (0, _defineProperty2.default)(this, "ensureFactoriesExist", () => {
      this.embeddableFactoryDefinitions.forEach(def => this.ensureFactoryExists(def.type));
    });
    (0, _defineProperty2.default)(this, "ensureFactoryExists", type => {
      if (!this.embeddableFactories.get(type)) {
        const def = this.embeddableFactoryDefinitions.get(type);
        if (!def) return;
        this.embeddableFactories.set(type, this.customEmbeddableFactoryProvider ? this.customEmbeddableFactoryProvider(def) : (0, _lib.defaultEmbeddableFactoryProvider)(def));
      }
    });
  }
  setup(core, {
    uiActions
  }) {
    (0, _services.setTheme)(core.theme);
    (0, _bootstrap.bootstrap)(uiActions);
    return {
      registerEmbeddableFactory: this.registerEmbeddableFactory,
      registerEnhancement: this.registerEnhancement,
      setCustomEmbeddableFactoryProvider: provider => {
        if (this.customEmbeddableFactoryProvider) {
          throw new Error('Custom embeddable factory provider is already set, and can only be set once');
        }
        this.customEmbeddableFactoryProvider = provider;
      }
    };
  }
  start(core, {
    uiActions,
    inspector,
    savedObjectsManagement,
    savedObjectsTaggingOss
  }) {
    this.embeddableFactoryDefinitions.forEach(def => {
      this.embeddableFactories.set(def.type, this.customEmbeddableFactoryProvider ? this.customEmbeddableFactoryProvider(def) : (0, _lib.defaultEmbeddableFactoryProvider)(def));
    });
    const {
      overlays,
      theme,
      uiSettings
    } = core;
    const dateFormat = uiSettings.get(_public.UI_SETTINGS.DATE_FORMAT);
    const commonlyUsedRanges = uiSettings.get(_public.UI_SETTINGS.TIMEPICKER_QUICK_RANGES);
    const timeRangeBadge = new _custom_time_range_badge.CustomTimeRangeBadge(overlays, theme, commonlyUsedRanges, dateFormat);
    uiActions.addTriggerAction(_lib.PANEL_BADGE_TRIGGER, timeRangeBadge);
    this.appListSubscription = core.application.applications$.subscribe(appList => {
      this.appList = appList;
    });
    this.stateTransferService = new _state_transfer.EmbeddableStateTransfer(core.application.navigateToApp, core.application.currentAppId$, this.appList);
    this.isRegistryReady = true;
    const getEmbeddablePanelHoc = () => ({
      embeddable,
      hideHeader,
      containerContext,
      index
    }) => /*#__PURE__*/_react.default.createElement(_lib.EmbeddablePanel, {
      hideHeader: hideHeader,
      embeddable: embeddable,
      index: index,
      stateTransfer: this.stateTransferService,
      getActions: uiActions.getTriggerCompatibleActions,
      getEmbeddableFactory: this.getEmbeddableFactory,
      getAllEmbeddableFactories: this.getEmbeddableFactories,
      dateFormat: dateFormat,
      commonlyUsedRanges: commonlyUsedRanges,
      overlays: overlays,
      notifications: core.notifications,
      application: core.application,
      inspector: inspector,
      SavedObjectFinder: (0, _public2.getSavedObjectFinder)(core.uiSettings, core.http, savedObjectsManagement, savedObjectsTaggingOss === null || savedObjectsTaggingOss === void 0 ? void 0 : savedObjectsTaggingOss.getTaggingApi()),
      containerContext: containerContext,
      theme: theme
    });
    const commonContract = {
      getEmbeddableFactory: this.getEmbeddableFactory,
      getEnhancement: this.getEnhancement
    };
    const getAllMigrationsFn = () => (0, _get_all_migrations.getAllMigrations)(Array.from(this.embeddableFactories.values()), Array.from(this.enhancements.values()), (0, _lib2.getMigrateFunction)(commonContract));
    return {
      getEmbeddableFactory: this.getEmbeddableFactory,
      getEmbeddableFactories: this.getEmbeddableFactories,
      getAttributeService: (type, options) => new _attribute_service.AttributeService(type, core.notifications.toasts, options, this.getEmbeddableFactory),
      getStateTransfer: storage => storage ? new _state_transfer.EmbeddableStateTransfer(core.application.navigateToApp, core.application.currentAppId$, this.appList, storage) : this.stateTransferService,
      EmbeddablePanel: getEmbeddablePanelHoc(),
      telemetry: (0, _lib2.getTelemetryFunction)(commonContract),
      extract: (0, _lib2.getExtractFunction)(commonContract),
      inject: (0, _lib2.getInjectFunction)(commonContract),
      getAllMigrations: getAllMigrationsFn,
      migrateToLatest: state => {
        return (0, _common.migrateToLatest)(getAllMigrationsFn(), state);
      }
    };
  }
  stop() {
    if (this.appListSubscription) {
      this.appListSubscription.unsubscribe();
    }
  }
}
exports.EmbeddablePublicPlugin = EmbeddablePublicPlugin;