"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterableEmbeddableFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _filterable_embeddable = require("./filterable_embeddable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class FilterableEmbeddableFactory {
  constructor() {
    (0, _defineProperty2.default)(this, "type", _filterable_embeddable.FILTERABLE_EMBEDDABLE);
  }
  async isEditable() {
    return true;
  }
  getDisplayName() {
    return _i18n.i18n.translate('embeddableApi.samples.filterableEmbeddable.displayName', {
      defaultMessage: 'filterable'
    });
  }
  async create(initialInput, parent) {
    return new _filterable_embeddable.FilterableEmbeddable(initialInput, parent);
  }
}
exports.FilterableEmbeddableFactory = FilterableEmbeddableFactory;