"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EDIT_MODE_ACTION = void 0;
exports.createEditModeActionDefinition = createEditModeActionDefinition;
var _types = require("../../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const EDIT_MODE_ACTION = 'EDIT_MODE_ACTION';
exports.EDIT_MODE_ACTION = EDIT_MODE_ACTION;
function createEditModeActionDefinition() {
  return {
    id: EDIT_MODE_ACTION,
    type: EDIT_MODE_ACTION,
    getDisplayName: () => 'I only show up in edit mode',
    isCompatible: async context => context.embeddable.getInput().viewMode === _types.ViewMode.EDIT,
    execute: async () => {}
  };
}