"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PanelHeader = PanelHeader;
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireDefault(require("react"));
var _panel_options_menu = require("./panel_options_menu");
var _triggers = require("../../triggers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function renderBadges(badges, embeddable) {
  return badges.map(badge => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    key: badge.id,
    className: "embPanel__headerBadge",
    iconType: badge.getIconType({
      embeddable,
      trigger: _triggers.panelBadgeTrigger
    }),
    onClick: () => badge.execute({
      embeddable,
      trigger: _triggers.panelBadgeTrigger
    }),
    onClickAriaLabel: badge.getDisplayName({
      embeddable,
      trigger: _triggers.panelBadgeTrigger
    }),
    "data-test-subj": `embeddablePanelBadge-${badge.id}`
  }, badge.getDisplayName({
    embeddable,
    trigger: _triggers.panelBadgeTrigger
  })));
}
function renderNotifications(notifications, embeddable) {
  return notifications.map(notification => {
    const context = {
      embeddable
    };
    let badge = notification.MenuItem ? /*#__PURE__*/_react.default.createElement(notification.MenuItem, {
      key: notification.id,
      context: {
        embeddable,
        trigger: _triggers.panelNotificationTrigger
      }
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      "data-test-subj": `embeddablePanelNotification-${notification.id}`,
      key: notification.id,
      style: {
        marginTop: '4px',
        marginRight: '4px'
      },
      onClick: () => notification.execute({
        ...context,
        trigger: _triggers.panelNotificationTrigger
      })
    }, notification.getDisplayName({
      ...context,
      trigger: _triggers.panelNotificationTrigger
    }));
    if (notification.getDisplayNameTooltip) {
      const tooltip = notification.getDisplayNameTooltip({
        ...context,
        trigger: _triggers.panelNotificationTrigger
      });
      if (tooltip) {
        badge = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          position: "top",
          delay: "regular",
          content: tooltip,
          key: notification.id
        }, badge);
      }
    }
    return badge;
  });
}
function PanelHeader({
  title,
  description,
  index,
  isViewMode,
  hidePanelTitle,
  getActionContextMenuPanel,
  closeContextMenu,
  badges,
  notifications,
  embeddable,
  headerId,
  customizePanel
}) {
  const showTitle = !hidePanelTitle && (!isViewMode || title);
  const showPanelBar = !isViewMode || badges.length > 0 || notifications.length > 0 || showTitle || description;
  const classes = (0, _classnames.default)('embPanel__header', {
    'embPanel__header--floater': !showPanelBar
  });
  const placeholderTitle = _i18n.i18n.translate('embeddableApi.panel.placeholderTitle', {
    defaultMessage: '[No Title]'
  });
  const getAriaLabel = () => {
    return /*#__PURE__*/_react.default.createElement("span", {
      id: headerId
    }, showPanelBar && title ? _i18n.i18n.translate('embeddableApi.panel.enhancedDashboardPanelAriaLabel', {
      defaultMessage: 'Dashboard panel: {title}',
      values: {
        title: title || placeholderTitle
      }
    }) : _i18n.i18n.translate('embeddableApi.panel.dashboardPanelAriaLabel', {
      defaultMessage: 'Dashboard panel'
    }));
  };
  if (!showPanelBar) {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: classes
    }, /*#__PURE__*/_react.default.createElement(_panel_options_menu.PanelOptionsMenu, {
      getActionContextMenuPanel: getActionContextMenuPanel,
      isViewMode: isViewMode,
      closeContextMenu: closeContextMenu,
      title: title,
      index: index
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, getAriaLabel()));
  }
  const renderTitle = () => {
    let titleComponent;
    if (showTitle) {
      titleComponent = isViewMode ? /*#__PURE__*/_react.default.createElement("span", {
        className: (0, _classnames.default)('embPanel__titleText', {
          // eslint-disable-next-line @typescript-eslint/naming-convention
          embPanel__placeholderTitleText: !title
        })
      }, title || placeholderTitle) : customizePanel ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        color: "text",
        "data-test-subj": 'embeddablePanelTitleLink',
        className: (0, _classnames.default)('embPanel__titleText', {
          // eslint-disable-next-line @typescript-eslint/naming-convention
          embPanel__placeholderTitleText: !title
        }),
        "aria-label": _i18n.i18n.translate('embeddableApi.panel.editTitleAriaLabel', {
          defaultMessage: 'Click to edit title: {title}',
          values: {
            title: title || placeholderTitle
          }
        }),
        onClick: () => customizePanel.execute({
          embeddable
        })
      }, title || placeholderTitle) : null;
    }
    return description ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: description,
      delay: "regular",
      position: "top",
      anchorClassName: "embPanel__titleTooltipAnchor"
    }, /*#__PURE__*/_react.default.createElement("span", {
      className: "embPanel__titleInner"
    }, titleComponent, " ", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "iInCircle",
      color: "subdued"
    }))) : /*#__PURE__*/_react.default.createElement("span", {
      className: "embPanel__titleInner"
    }, titleComponent);
  };
  const titleClasses = (0, _classnames.default)('embPanel__title', {
    'embPanel--dragHandle': !isViewMode
  });
  return /*#__PURE__*/_react.default.createElement("figcaption", {
    className: classes,
    "data-test-subj": `embeddablePanelHeading-${(title || '').replace(/\s/g, '')}`
  }, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": "dashboardPanelTitle",
    className: titleClasses
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, getAriaLabel()), renderTitle(), renderBadges(badges, embeddable)), renderNotifications(notifications, embeddable), /*#__PURE__*/_react.default.createElement(_panel_options_menu.PanelOptionsMenu, {
    isViewMode: isViewMode,
    getActionContextMenuPanel: getActionContextMenuPanel,
    closeContextMenu: closeContextMenu,
    title: title,
    index: index
  }));
}