"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectFinderCreateNew = SavedObjectFinderCreateNew;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function SavedObjectFinderCreateNew({
  menuItems
}) {
  const [isCreateMenuOpen, setCreateMenuOpen] = (0, _react.useState)(false);
  const toggleCreateMenu = () => {
    setCreateMenuOpen(!isCreateMenuOpen);
  };
  const closeCreateMenu = () => {
    setCreateMenuOpen(false);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "createNew",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "createNew",
      iconType: "plusInCircle",
      iconSide: "left",
      onClick: toggleCreateMenu,
      fill: true
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "embeddableApi.addPanel.createNewDefaultOption",
      defaultMessage: "Create new"
    })),
    isOpen: isCreateMenuOpen,
    closePopover: closeCreateMenu,
    panelPaddingSize: "none",
    anchorPosition: "downRight"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: menuItems
  }));
}