"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openAddPanelFlyout = openAddPanelFlyout;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _add_panel_flyout = require("./add_panel_flyout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function openAddPanelFlyout(options) {
  const {
    embeddable,
    getFactory,
    getAllFactories,
    overlays,
    notifications,
    SavedObjectFinder,
    showCreateNewMenu,
    reportUiCounter,
    theme,
    onAddPanel
  } = options;
  const flyoutSession = overlays.openFlyout((0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_add_panel_flyout.AddPanelFlyout, {
    container: embeddable,
    onAddPanel: onAddPanel,
    onClose: () => {
      if (flyoutSession) {
        flyoutSession.close();
      }
    },
    getFactory: getFactory,
    getAllFactories: getAllFactories,
    notifications: notifications,
    reportUiCounter: reportUiCounter,
    SavedObjectFinder: SavedObjectFinder,
    showCreateNewMenu: showCreateNewMenu
  }), {
    theme$: theme.theme$
  }), {
    'data-test-subj': 'dashboardAddPanel',
    ownFocus: true
  });
  return flyoutSession;
}